/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;

public class DefaultIndexProviderMapTest {
    @Test
    public void shouldNotSupportMultipleProvidersWithSameDescriptor() {
        IndexProvider.Descriptor descriptor = new IndexProvider.Descriptor("provider", "1.2");
        IndexProvider provider1 = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider1.getProviderDescriptor()).thenReturn((Object)descriptor);
        IndexProvider provider2 = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider2.getProviderDescriptor()).thenReturn((Object)descriptor);
        try {
            new DefaultIndexProviderMap(provider1, Collections.singletonList(provider2));
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnLookupOnUnknownProvider() {
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)new IndexProvider.Descriptor("provider", "1.2"));
        try {
            new DefaultIndexProviderMap(provider).lookup(new IndexProvider.Descriptor("provider2", "1.2"));
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

