/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.diagnostics;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.diagnostics.DiagnosticsReportSources;
import org.neo4j.diagnostics.DiagnosticsReporter;
import org.neo4j.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.diagnostics.NonInteractiveProgress;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class DiagnosticsReporterTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void dumpFiles() throws Exception {
        DiagnosticsReporter reporter = this.setupDiagnosticsReporter();
        Path destination = this.testDirectory.file("logs.zip").toPath();
        reporter.dump(Collections.singleton("logs"), destination, (DiagnosticsReporterProgress)Mockito.mock(DiagnosticsReporterProgress.class), true);
        this.verifyContent(destination);
    }

    @Test
    public void shouldContinueAfterError() throws Exception {
        DiagnosticsReporter reporter = new DiagnosticsReporter();
        MyProvider myProvider = new MyProvider(this.fileSystemRule.get());
        reporter.registerOfflineProvider((DiagnosticsOfflineReportProvider)myProvider);
        myProvider.addFile("logs/a.txt", this.createNewFileWithContent("a.txt", "file a"));
        Path destination = this.testDirectory.file("logs.zip").toPath();
        HashSet<String> classifiers = new HashSet<String>();
        classifiers.add("logs");
        classifiers.add("fail");
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream out = new PrintStream(baos);
            NonInteractiveProgress progress = new NonInteractiveProgress(out, false);
            reporter.dump(classifiers, destination, (DiagnosticsReporterProgress)progress, true);
            Assert.assertThat((Object)baos.toString(), (Matcher)CoreMatchers.is((Object)String.format("1/2 fail.txt%n....................  20%%%n..........%nError: Step failed%n2/2 logs/a.txt%n....................  20%%%n....................  40%%%n....................  60%%%n....................  80%%%n.................... 100%%%n%n", new Object[0])));
        }
        URI uri = URI.create("jar:file:" + destination.toAbsolutePath().toUri().getRawPath());
        try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            List<String> fileA = Files.readAllLines(fs.getPath("logs/a.txt", new String[0]));
            Assert.assertEquals((long)1L, (long)fileA.size());
            Assert.assertEquals((Object)"file a", (Object)fileA.get(0));
        }
    }

    @Test
    public void supportPathsWithSpaces() throws IOException {
        DiagnosticsReporter reporter = this.setupDiagnosticsReporter();
        Path destination = this.testDirectory.file("log files.zip").toPath();
        reporter.dump(Collections.singleton("logs"), destination, (DiagnosticsReporterProgress)Mockito.mock(DiagnosticsReporterProgress.class), true);
        this.verifyContent(destination);
    }

    private File createNewFileWithContent(String name, String content) throws IOException {
        Path file = this.testDirectory.file(name).toPath();
        Files.write(file, content.getBytes(), new OpenOption[0]);
        return file.toFile();
    }

    private DiagnosticsReporter setupDiagnosticsReporter() throws IOException {
        DiagnosticsReporter reporter = new DiagnosticsReporter();
        MyProvider myProvider = new MyProvider(this.fileSystemRule.get());
        reporter.registerOfflineProvider((DiagnosticsOfflineReportProvider)myProvider);
        myProvider.addFile("logs/a.txt", this.createNewFileWithContent("a.txt", "file a"));
        myProvider.addFile("logs/b.txt", this.createNewFileWithContent("b.txt", "file b"));
        return reporter;
    }

    private void verifyContent(Path destination) throws IOException {
        URI uri = URI.create("jar:file:" + destination.toAbsolutePath().toUri().getRawPath());
        try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            List<String> fileA = Files.readAllLines(fs.getPath("logs/a.txt", new String[0]));
            Assert.assertEquals((long)1L, (long)fileA.size());
            Assert.assertEquals((Object)"file a", (Object)fileA.get(0));
            List<String> fileB = Files.readAllLines(fs.getPath("logs/b.txt", new String[0]));
            Assert.assertEquals((long)1L, (long)fileB.size());
            Assert.assertEquals((Object)"file b", (Object)fileB.get(0));
        }
    }

    private static class FailingSource
    implements DiagnosticsReportSource {
        private FailingSource() {
        }

        public String destinationPath() {
            return "fail.txt";
        }

        public void addToArchive(Path archiveDestination, DiagnosticsReporterProgress progress) {
            progress.percentChanged(30);
            throw new RuntimeException("You had it coming...");
        }

        public long estimatedSize(DiagnosticsReporterProgress progress) {
            return 0L;
        }
    }

    static class MyProvider
    extends DiagnosticsOfflineReportProvider {
        private final FileSystemAbstraction fs;
        private List<DiagnosticsReportSource> logFiles = new ArrayList<DiagnosticsReportSource>();

        MyProvider(FileSystemAbstraction fs) {
            super("my-provider", "logs", new String[0]);
            this.fs = fs;
        }

        void addFile(String destination, File file) {
            this.logFiles.add(DiagnosticsReportSources.newDiagnosticsFile((String)destination, (FileSystemAbstraction)this.fs, (File)file));
        }

        public void init(FileSystemAbstraction fs, Config config, File storeDirectory) {
        }

        public List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
            ArrayList<DiagnosticsReportSource> sources = new ArrayList<DiagnosticsReportSource>();
            if (classifiers.contains("fail")) {
                sources.add(new FailingSource());
            }
            if (classifiers.contains("logs")) {
                sources.addAll(this.logFiles);
            }
            return sources;
        }
    }
}

