/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.FacadeMethod;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public class NodeFacadeMethods {
    private static final RelationshipType FOO = RelationshipType.withName((String)"foo");
    private static final RelationshipType BAR = RelationshipType.withName((String)"bar");
    private static final Label QUUX = Label.label((String)"quux");
    private static final FacadeMethod<Node> HAS_PROPERTY = new FacadeMethod<Node>("boolean hasProperty( String key )"){

        @Override
        public void call(Node node) {
            node.hasProperty("foo");
        }
    };
    private static final FacadeMethod<Node> GET_PROPERTY = new FacadeMethod<Node>("Object getProperty( String key )"){

        @Override
        public void call(Node node) {
            node.getProperty("foo");
        }
    };
    private static final FacadeMethod<Node> GET_PROPERTY_WITH_DEFAULT = new FacadeMethod<Node>("Object getProperty( String key, Object defaultValue )"){

        @Override
        public void call(Node node) {
            node.getProperty("foo", (Object)42);
        }
    };
    private static final FacadeMethod<Node> SET_PROPERTY = new FacadeMethod<Node>("void setProperty( String key, Object value )"){

        @Override
        public void call(Node node) {
            node.setProperty("foo", (Object)42);
        }
    };
    private static final FacadeMethod<Node> REMOVE_PROPERTY = new FacadeMethod<Node>("Object removeProperty( String key )"){

        @Override
        public void call(Node node) {
            node.removeProperty("foo");
        }
    };
    private static final FacadeMethod<Node> GET_PROPERTY_KEYS = new FacadeMethod<Node>("Iterable<String> getPropertyKeys()"){

        @Override
        public void call(Node node) {
            NodeFacadeMethods.consume(node.getPropertyKeys());
        }
    };
    private static final FacadeMethod<Node> DELETE = new FacadeMethod<Node>("void delete()"){

        @Override
        public void call(Node node) {
            node.delete();
        }
    };
    private static final FacadeMethod<Node> GET_RELATIONSHIPS = new FacadeMethod<Node>("Iterable<Relationship> getRelationships()"){

        @Override
        public void call(Node node) {
            NodeFacadeMethods.consume(node.getRelationships());
        }
    };
    private static final FacadeMethod<Node> HAS_RELATIONSHIP = new FacadeMethod<Node>("boolean hasRelationship()"){

        @Override
        public void call(Node node) {
            node.hasRelationship();
        }
    };
    private static final FacadeMethod<Node> GET_RELATIONSHIPS_BY_TYPE = new FacadeMethod<Node>("Iterable<Relationship> getRelationships( RelationshipType... types )"){

        @Override
        public void call(Node node) {
            NodeFacadeMethods.consume(node.getRelationships(new RelationshipType[]{FOO, BAR}));
        }
    };
    private static final FacadeMethod<Node> GET_RELATIONSHIPS_BY_DIRECTION_AND_TYPES = new FacadeMethod<Node>("Iterable<Relationship> getRelationships( Direction direction, RelationshipType... types )"){

        @Override
        public void call(Node node) {
            NodeFacadeMethods.consume(node.getRelationships(Direction.BOTH, new RelationshipType[]{FOO, BAR}));
        }
    };
    private static final FacadeMethod<Node> HAS_RELATIONSHIP_BY_TYPE = new FacadeMethod<Node>("boolean hasRelationship( RelationshipType... types )"){

        @Override
        public void call(Node node) {
            node.hasRelationship(new RelationshipType[]{FOO});
        }
    };
    private static final FacadeMethod<Node> HAS_RELATIONSHIP_BY_DIRECTION_AND_TYPE = new FacadeMethod<Node>("boolean hasRelationship( Direction direction, RelationshipType... types )"){

        @Override
        public void call(Node node) {
            node.hasRelationship(Direction.BOTH, new RelationshipType[]{FOO});
        }
    };
    private static final FacadeMethod<Node> GET_RELATIONSHIPS_BY_DIRECTION = new FacadeMethod<Node>("Iterable<Relationship> getRelationships( Direction dir )"){

        @Override
        public void call(Node node) {
            NodeFacadeMethods.consume(node.getRelationships(Direction.BOTH));
        }
    };
    private static final FacadeMethod<Node> HAS_RELATIONSHIP_BY_DIRECTION = new FacadeMethod<Node>("boolean hasRelationship( Direction dir )"){

        @Override
        public void call(Node node) {
            node.hasRelationship(Direction.BOTH);
        }
    };
    private static final FacadeMethod<Node> GET_RELATIONSHIPS_BY_TYPE_AND_DIRECTION = new FacadeMethod<Node>("Iterable<Relationship> getRelationships( RelationshipType type, Direction dir );"){

        @Override
        public void call(Node node) {
            NodeFacadeMethods.consume(node.getRelationships(FOO, Direction.BOTH));
        }
    };
    private static final FacadeMethod<Node> HAS_RELATIONSHIP_BY_TYPE_AND_DIRECTION = new FacadeMethod<Node>("boolean hasRelationship( RelationshipType type, Direction dir )"){

        @Override
        public void call(Node node) {
            node.hasRelationship(FOO, Direction.BOTH);
        }
    };
    private static final FacadeMethod<Node> GET_SINGLE_RELATIONSHIP = new FacadeMethod<Node>("Relationship getSingleRelationship( RelationshipType type, Direction dir )"){

        @Override
        public void call(Node node) {
            node.getSingleRelationship(FOO, Direction.BOTH);
        }
    };
    private static final FacadeMethod<Node> CREATE_RELATIONSHIP_TO = new FacadeMethod<Node>("Relationship createRelationshipTo( Node otherNode, RelationshipType type )"){

        @Override
        public void call(Node node) {
            node.createRelationshipTo(node, FOO);
        }
    };
    private static final FacadeMethod<Node> ADD_LABEL = new FacadeMethod<Node>("void addLabel( Label label )"){

        @Override
        public void call(Node node) {
            node.addLabel(QUUX);
        }
    };
    private static final FacadeMethod<Node> REMOVE_LABEL = new FacadeMethod<Node>("void removeLabel( Label label )"){

        @Override
        public void call(Node node) {
            node.removeLabel(QUUX);
        }
    };
    private static final FacadeMethod<Node> HAS_LABEL = new FacadeMethod<Node>("boolean hasLabel( Label label )"){

        @Override
        public void call(Node node) {
            node.hasLabel(QUUX);
        }
    };
    private static final FacadeMethod<Node> GET_LABELS = new FacadeMethod<Node>("ResourceIterable<Label> getLabels()"){

        @Override
        public void call(Node node) {
            NodeFacadeMethods.consume(node.getLabels());
        }
    };
    static final Iterable<FacadeMethod<Node>> ALL_NODE_FACADE_METHODS = Collections.unmodifiableCollection(Arrays.asList(HAS_PROPERTY, GET_PROPERTY, GET_PROPERTY_WITH_DEFAULT, SET_PROPERTY, REMOVE_PROPERTY, GET_PROPERTY_KEYS, DELETE, GET_RELATIONSHIPS, HAS_RELATIONSHIP, GET_RELATIONSHIPS_BY_TYPE, GET_RELATIONSHIPS_BY_DIRECTION_AND_TYPES, HAS_RELATIONSHIP_BY_TYPE, HAS_RELATIONSHIP_BY_DIRECTION_AND_TYPE, GET_RELATIONSHIPS_BY_DIRECTION, HAS_RELATIONSHIP_BY_DIRECTION, GET_RELATIONSHIPS_BY_TYPE_AND_DIRECTION, HAS_RELATIONSHIP_BY_TYPE_AND_DIRECTION, GET_SINGLE_RELATIONSHIP, CREATE_RELATIONSHIP_TO, ADD_LABEL, REMOVE_LABEL, HAS_LABEL, GET_LABELS));

    private NodeFacadeMethods() {
    }

    private static void consume(Iterable<?> iterable) {
        for (Object o : iterable) {
            Assert.assertNotNull(o);
        }
    }
}

