/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.BarService;
import org.neo4j.helpers.BazService;
import org.neo4j.helpers.FooService;
import org.neo4j.helpers.Service;

public class ServiceTest {
    @Test
    public void shouldLoadServiceInDefaultEnvironment() {
        FooService fooService = (FooService)Service.load(FooService.class, (String)"foo");
        Assert.assertTrue((boolean)(fooService instanceof BarService));
    }

    @Test
    public void whenContextCallsLoaderBlocksServicesFolderShouldLoadClassFromKernelClassloader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new ServiceBlockClassLoader(contextClassLoader));
            FooService fooService = (FooService)Service.load(FooService.class, (String)"foo");
            Assert.assertTrue((boolean)(fooService instanceof BarService));
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Test
    public void whenContextClassLoaderOverridesServiceShouldLoadThatClass() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new ServiceRedirectClassLoader(contextClassLoader));
            FooService fooService = (FooService)Service.load(FooService.class, (String)"foo");
            Assert.assertTrue((boolean)(fooService instanceof BazService));
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void whenContextClassLoaderDuplicatesServiceShouldLoadItOnce() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Service.class.getClassLoader());
            Iterable services = Service.load(FooService.class);
            int size = 0;
            for (FooService fooService : services) {
                ++size;
            }
            Assert.assertEquals((long)1L, (long)size);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static final class ServiceRedirectClassLoader
    extends ClassLoader {
        ServiceRedirectClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public URL getResource(String name) {
            return name.startsWith("META-INF/services") ? super.getResource("test/" + name) : super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return name.startsWith("META-INF/services") ? super.getResources("test/" + name) : super.getResources(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return name.startsWith("META-INF/services") ? super.getResourceAsStream("test/" + name) : super.getResourceAsStream(name);
        }
    }

    private static final class ServiceBlockClassLoader
    extends ClassLoader {
        ServiceBlockClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public URL getResource(String name) {
            return name.startsWith("META-INF/services") ? null : super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return name.startsWith("META-INF/services") ? Collections.enumeration(Collections.emptySet()) : super.getResources(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return name.startsWith("META-INF/services") ? null : super.getResourceAsStream(name);
        }
    }
}

