/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MultiSet;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.RootCauseMatcher;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RecoveryCorruptedTransactionLogIT {
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fileSystemRule);
    private final ExpectedException expectedException = ExpectedException.none();
    private final RandomRule random = new RandomRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.directory).around((TestRule)this.expectedException).around((TestRule)this.random);
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private final RecoveryMonitor recoveryMonitor = new RecoveryMonitor();
    private File storeDir;
    private Monitors monitors = new Monitors();
    private LogFiles logFiles;
    private TestGraphDatabaseFactory databaseFactory;

    @Before
    public void setUp() throws Exception {
        this.storeDir = this.directory.graphDbDir();
        this.monitors.addMonitorListener((Object)this.recoveryMonitor, new String[0]);
        this.databaseFactory = new TestGraphDatabaseFactory().setInternalLogProvider((LogProvider)this.logProvider).setMonitors(this.monitors);
        this.logFiles = this.buildDefaultLogFiles();
    }

    @Test
    public void evenTruncateNewerTransactionLogFile() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        TransactionIdStore transactionIdStore = this.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            this.generateTransaction(database);
        }
        long numberOfClosedTransactions = this.getTransactionIdStore(database).getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        database.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomBytes);
        database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.fail_on_corrupted_log_files, "false").newGraphDatabase();
        database.shutdown();
        Assert.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
    }

    @Test
    public void doNotTruncateNewerTransactionLogFileWhenFailOnError() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        for (int i = 0; i < 10; ++i) {
            this.generateTransaction(database);
        }
        database.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomPositiveBytes);
        this.expectedException.expectCause(new RootCauseMatcher<UnsupportedLogVersionException>(UnsupportedLogVersionException.class));
        database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        database.shutdown();
    }

    @Test
    public void truncateNewerTransactionLogFileWhenForced() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        for (int i = 0; i < 10; ++i) {
            this.generateTransaction(database);
        }
        TransactionIdStore transactionIdStore = this.getTransactionIdStore(database);
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - 1L;
        database.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomBytes);
        database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.fail_on_corrupted_log_files, "false").newGraphDatabase();
        database.shutdown();
        this.logProvider.assertContainsMessageContaining("Fail to read transaction log version 0.");
        this.logProvider.assertContainsMessageContaining("Fail to read transaction log version 0. Last valid transaction start offset is: 5668.");
        Assert.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
    }

    @Test
    public void recoverFirstCorruptedTransactionSingleFileNoCheckpoint() throws IOException {
        this.addCorruptedCommandsToLastLogFile();
        GraphDatabaseService recoveredDatabase = this.databaseFactory.newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.fail_on_corrupted_log_files, "false").newGraphDatabase();
        recoveredDatabase.shutdown();
        this.logProvider.assertContainsMessageContaining("Fail to read transaction log version 0.");
        this.logProvider.assertContainsMessageContaining("Fail to read first transaction of log version 0.");
        this.logProvider.assertContainsMessageContaining("Recovery required from position LogPosition{logVersion=0, byteOffset=16}");
        this.logProvider.assertContainsMessageContaining("Fail to recover all transactions. Any later transactions after position LogPosition{logVersion=0, byteOffset=16} are unreadable and will be truncated.");
        Assert.assertEquals((long)0L, (long)this.logFiles.getHighestLogVersion());
        MultiSet<Class> logEntriesDistribution = this.getLogEntriesDistribution(this.logFiles);
        Assert.assertEquals((long)1L, (long)logEntriesDistribution.size());
        Assert.assertEquals((long)1L, (long)logEntriesDistribution.count(CheckPoint.class));
    }

    @Test
    public void failToRecoverFirstCorruptedTransactionSingleFileNoCheckpointIfFailOnCorruption() throws IOException {
        this.addCorruptedCommandsToLastLogFile();
        this.expectedException.expectCause(new RootCauseMatcher<NegativeArraySizeException>(NegativeArraySizeException.class));
        GraphDatabaseService recoveredDatabase = this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        recoveredDatabase.shutdown();
    }

    @Test
    public void recoverNotAFirstCorruptedTransactionSingleFileNoCheckpoint() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        TransactionIdStore transactionIdStore = this.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            this.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        database.shutdown();
        File highestLogFile = this.logFiles.getHighestLogFile();
        long originalFileLength = highestLogFile.length();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile();
        long modifiedFileLength = highestLogFile.length();
        Assert.assertThat((Object)modifiedFileLength, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(originalFileLength)));
        database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.fail_on_corrupted_log_files, "false").newGraphDatabase();
        database.shutdown();
        this.logProvider.assertContainsMessageContaining("Fail to read transaction log version 0.");
        this.logProvider.assertContainsMessageContaining("Recovery required from position LogPosition{logVersion=0, byteOffset=16}");
        this.logProvider.assertContainsMessageContaining("Fail to recover all transactions.");
        this.logProvider.assertContainsMessageContaining("Any later transaction after LogPosition{logVersion=0, byteOffset=6245} are unreadable and will be truncated.");
        Assert.assertEquals((long)0L, (long)this.logFiles.getHighestLogVersion());
        MultiSet<Class> logEntriesDistribution = this.getLogEntriesDistribution(this.logFiles);
        Assert.assertEquals((long)1L, (long)logEntriesDistribution.count(CheckPoint.class));
        Assert.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assert.assertEquals((long)originalFileLength, (long)highestLogFile.length());
    }

    @Test
    public void recoverNotAFirstCorruptedTransactionMultipleFilesNoCheckpoints() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        TransactionIdStore transactionIdStore = this.getTransactionIdStore(database);
        long lastClosedTrandactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        this.generateTransactionsAndRotate(database, 3);
        for (int i = 0; i < 7; ++i) {
            this.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTrandactionBeforeStart;
        database.shutdown();
        LogFiles logFiles = this.buildDefaultLogFiles();
        File highestLogFile = logFiles.getHighestLogFile();
        long originalFileLength = highestLogFile.length();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile();
        long modifiedFileLength = highestLogFile.length();
        Assert.assertThat((Object)modifiedFileLength, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(originalFileLength)));
        database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.fail_on_corrupted_log_files, "false").newGraphDatabase();
        database.shutdown();
        this.logProvider.assertContainsMessageContaining("Fail to read transaction log version 3.");
        this.logProvider.assertContainsMessageContaining("Recovery required from position LogPosition{logVersion=0, byteOffset=16}");
        this.logProvider.assertContainsMessageContaining("Fail to recover all transactions.");
        this.logProvider.assertContainsMessageContaining("Any later transaction after LogPosition{logVersion=3, byteOffset=4632} are unreadable and will be truncated.");
        Assert.assertEquals((long)3L, (long)logFiles.getHighestLogVersion());
        MultiSet<Class> logEntriesDistribution = this.getLogEntriesDistribution(logFiles);
        Assert.assertEquals((long)1L, (long)logEntriesDistribution.count(CheckPoint.class));
        Assert.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assert.assertEquals((long)originalFileLength, (long)highestLogFile.length());
    }

    @Test
    public void recoverNotAFirstCorruptedTransactionMultipleFilesMultipleCheckpoints() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        long transactionsToRecover = 7L;
        this.generateTransactionsAndRotateWithCheckpoint(database, 3);
        int i = 0;
        while ((long)i < transactionsToRecover) {
            this.generateTransaction(database);
            ++i;
        }
        database.shutdown();
        File highestLogFile = this.logFiles.getHighestLogFile();
        long originalFileLength = highestLogFile.length();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile();
        long modifiedFileLength = highestLogFile.length();
        Assert.assertThat((Object)modifiedFileLength, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(originalFileLength)));
        database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.fail_on_corrupted_log_files, "false").newGraphDatabase();
        database.shutdown();
        this.logProvider.assertContainsMessageContaining("Fail to read transaction log version 3.");
        this.logProvider.assertContainsMessageContaining("Recovery required from position LogPosition{logVersion=3, byteOffset=593}");
        this.logProvider.assertContainsMessageContaining("Fail to recover all transactions.");
        this.logProvider.assertContainsMessageContaining("Any later transaction after LogPosition{logVersion=3, byteOffset=4650} are unreadable and will be truncated.");
        Assert.assertEquals((long)3L, (long)this.logFiles.getHighestLogVersion());
        MultiSet<Class> logEntriesDistribution = this.getLogEntriesDistribution(this.logFiles);
        Assert.assertEquals((long)4L, (long)logEntriesDistribution.count(CheckPoint.class));
        Assert.assertEquals((long)transactionsToRecover, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assert.assertEquals((long)originalFileLength, (long)highestLogFile.length());
    }

    @Test
    public void recoverFirstCorruptedTransactionAfterCheckpointInLastLogFile() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        this.generateTransactionsAndRotate(database, 5);
        database.shutdown();
        File highestLogFile = this.logFiles.getHighestLogFile();
        long originalFileLength = highestLogFile.length();
        this.addCorruptedCommandsToLastLogFile();
        long modifiedFileLength = highestLogFile.length();
        Assert.assertThat((Object)modifiedFileLength, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(originalFileLength)));
        database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.fail_on_corrupted_log_files, "false").newGraphDatabase();
        database.shutdown();
        this.logProvider.assertContainsMessageContaining("Fail to read transaction log version 5.");
        this.logProvider.assertContainsMessageContaining("Fail to read first transaction of log version 5.");
        this.logProvider.assertContainsMessageContaining("Recovery required from position LogPosition{logVersion=5, byteOffset=593}");
        this.logProvider.assertContainsMessageContaining("Fail to recover all transactions. Any later transactions after position LogPosition{logVersion=5, byteOffset=593} are unreadable and will be truncated.");
        Assert.assertEquals((long)5L, (long)this.logFiles.getHighestLogVersion());
        MultiSet<Class> logEntriesDistribution = this.getLogEntriesDistribution(this.logFiles);
        Assert.assertEquals((long)1L, (long)logEntriesDistribution.count(CheckPoint.class));
        Assert.assertEquals((long)originalFileLength, (long)highestLogFile.length());
    }

    @Test
    public void repetitiveRecoveryOfCorruptedLogs() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        this.generateTransactionsAndRotate(database, 4, false);
        database.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        for (int expectedRecoveredTransactions = 7; expectedRecoveredTransactions > 0; --expectedRecoveredTransactions) {
            this.truncateBytesFromLastLogFile(1 + this.random.nextInt(10));
            this.databaseFactory.newEmbeddedDatabase(this.storeDir).shutdown();
            int numberOfRecoveredTransactions = this.recoveryMonitor.getNumberOfRecoveredTransactions();
            Assert.assertEquals((long)expectedRecoveredTransactions, (long)numberOfRecoveredTransactions);
            this.removeLastCheckpointRecordFromLastLogFile();
        }
    }

    @Test
    public void repetitiveRecoveryIfCorruptedLogsWithCheckpoints() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        this.generateTransactionsAndRotate(database, 4, true);
        database.shutdown();
        while (this.logFiles.getHighestLogVersion() > 0L) {
            int bytesToTrim = 1 + this.random.nextInt(100);
            this.truncateBytesFromLastLogFile(bytesToTrim);
            this.databaseFactory.newEmbeddedDatabase(this.storeDir).shutdown();
            int numberOfRecoveredTransactions = this.recoveryMonitor.getNumberOfRecoveredTransactions();
            Assert.assertThat((Object)numberOfRecoveredTransactions, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        }
        File corruptedLogArchives = new File(this.storeDir, "corrupted-neostore.transaction.db");
        Assert.assertThat((Object)corruptedLogArchives.listFiles(), (Matcher)Matchers.not((Matcher)Matchers.emptyArray()));
    }

    @Test
    public void repetitiveRecoveryIfCorruptedLogsSmallTailsWithCheckpoints() throws IOException {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.databaseFactory.newEmbeddedDatabase(this.storeDir);
        this.generateTransactionsAndRotate(database, 4, true);
        database.shutdown();
        byte[] trimSizes = new byte[]{4, 22};
        int trimSize = 0;
        while (this.logFiles.getHighestLogVersion() > 0L) {
            byte bytesToTrim = trimSizes[trimSize++ % trimSizes.length];
            this.truncateBytesFromLastLogFile(bytesToTrim);
            this.databaseFactory.newEmbeddedDatabase(this.storeDir).shutdown();
            int numberOfRecoveredTransactions = this.recoveryMonitor.getNumberOfRecoveredTransactions();
            Assert.assertThat((Object)numberOfRecoveredTransactions, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        }
        File corruptedLogArchives = new File(this.storeDir, "corrupted-neostore.transaction.db");
        Assert.assertThat((Object)corruptedLogArchives.listFiles(), (Matcher)Matchers.not((Matcher)Matchers.emptyArray()));
    }

    private TransactionIdStore getTransactionIdStore(GraphDatabaseAPI database) {
        return (TransactionIdStore)database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
    }

    private void removeLastCheckpointRecordFromLastLogFile() throws IOException {
        LogPosition checkpointPosition = null;
        LogFile transactionLogFile = this.logFiles.getLogFile();
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader();
        LogPosition startPosition = LogPosition.start((long)this.logFiles.getHighestLogVersion());
        try (ReadableLogChannel reader = transactionLogFile.getReader(startPosition);){
            LogEntry logEntry;
            do {
                if (!((logEntry = entryReader.readLogEntry((ReadableClosablePositionAwareChannel)reader)) instanceof CheckPoint)) continue;
                checkpointPosition = ((CheckPoint)logEntry).getLogPosition();
            } while (logEntry != null);
        }
        if (checkpointPosition != null) {
            var6_6 = null;
            try (StoreChannel storeChannel = this.fileSystemRule.open(this.logFiles.getHighestLogFile(), OpenMode.READ_WRITE);){
                storeChannel.truncate(checkpointPosition.getByteOffset());
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
    }

    private void truncateBytesFromLastLogFile(long bytesToTrim) throws IOException {
        File highestLogFile = this.logFiles.getHighestLogFile();
        long fileSize = this.fileSystemRule.getFileSize(highestLogFile);
        if (bytesToTrim > fileSize) {
            this.fileSystemRule.deleteFile(highestLogFile);
        } else {
            this.fileSystemRule.truncate(highestLogFile, fileSize - bytesToTrim);
        }
    }

    private void addRandomBytesToLastLogFile(Supplier<Byte> byteSource) throws IOException {
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            LogFile transactionLogFile = this.logFiles.getLogFile();
            lifespan.add((Lifecycle)this.logFiles);
            FlushablePositionAwareChannel logFileWriter = transactionLogFile.getWriter();
            for (int i = 0; i < 10; ++i) {
                logFileWriter.put(byteSource.get().byteValue());
            }
        }
    }

    private byte randomPositiveBytes() {
        return (byte)this.random.nextInt(0, 127);
    }

    private byte randomBytes() {
        return (byte)this.random.nextInt(-128, 127);
    }

    private void addCorruptedCommandsToLastLogFile() throws IOException {
        PositiveLogFilesBasedLogVersionRepository versionRepository = new PositiveLogFilesBasedLogVersionRepository(this.logFiles);
        LogFiles internalLogFiles = LogFilesBuilder.builder((File)this.storeDir, (FileSystemAbstraction)this.fileSystemRule).withLogVersionRepository((LogVersionRepository)versionRepository).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{internalLogFiles});){
            LogFile transactionLogFile = internalLogFiles.getLogFile();
            FlushablePositionAwareChannel channel = transactionLogFile.getWriter();
            TransactionLogWriter writer = new TransactionLogWriter((LogEntryWriter)new CorruptedLogEntryWriter((FlushableChannel)channel));
            ArrayList<Object> commands = new ArrayList<Object>();
            commands.add(new Command.PropertyCommand(new PropertyRecord(1L), new PropertyRecord(2L)));
            commands.add(new Command.NodeCommand(new NodeRecord(2L), new NodeRecord(3L)));
            PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
            writer.append((TransactionRepresentation)transaction, 1000L);
        }
    }

    private MultiSet<Class> getLogEntriesDistribution(LogFiles logFiles) throws IOException {
        LogFile transactionLogFile = logFiles.getLogFile();
        LogPosition fileStartPosition = new LogPosition(0L, 16L);
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader();
        MultiSet multiset = new MultiSet();
        try (ReadableLogChannel fileReader = transactionLogFile.getReader(fileStartPosition);){
            LogEntry logEntry = entryReader.readLogEntry((ReadableClosablePositionAwareChannel)fileReader);
            while (logEntry != null) {
                multiset.add(logEntry.getClass());
                logEntry = entryReader.readLogEntry((ReadableClosablePositionAwareChannel)fileReader);
            }
        }
        return multiset;
    }

    private LogFiles buildDefaultLogFiles() throws IOException {
        return LogFilesBuilder.builder((File)this.storeDir, (FileSystemAbstraction)this.fileSystemRule).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).build();
    }

    private void generateTransactionsAndRotateWithCheckpoint(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        this.generateTransactionsAndRotate(database, logFilesToGenerate, true);
    }

    private void generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        this.generateTransactionsAndRotate(database, logFilesToGenerate, false);
    }

    private void generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate, boolean checkpoint) throws IOException {
        DependencyResolver resolver = database.getDependencyResolver();
        LogFiles logFiles = (LogFiles)resolver.resolveDependency(TransactionLogFiles.class);
        CheckPointer checkpointer = (CheckPointer)resolver.resolveDependency(CheckPointer.class);
        while (logFiles.getHighestLogVersion() < (long)logFilesToGenerate) {
            logFiles.getLogFile().rotate();
            this.generateTransaction(database);
            if (!checkpoint) continue;
            checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("testForcedCheckpoint"));
        }
    }

    private void generateTransaction(GraphDatabaseAPI database) {
        try (Transaction transaction = database.beginTx();){
            Node startNode = database.createNode(new Label[]{Label.label((String)"startNode")});
            startNode.setProperty("key", (Object)"value");
            Node endNode = database.createNode(new Label[]{Label.label((String)"endNode")});
            endNode.setProperty("key", (Object)"value");
            startNode.createRelationshipTo(endNode, RelationshipType.withName((String)"connects"));
            transaction.success();
        }
    }

    private static class PositiveLogFilesBasedLogVersionRepository
    implements LogVersionRepository {
        private long version;

        PositiveLogFilesBasedLogVersionRepository(LogFiles logFiles) {
            this.version = logFiles.getHighestLogVersion() == -1L ? 0L : logFiles.getHighestLogVersion();
        }

        public long getCurrentLogVersion() {
            return this.version;
        }

        public void setCurrentLogVersion(long version) {
            this.version = version;
        }

        public long incrementAndGetVersion() {
            ++this.version;
            return this.version;
        }
    }

    private static class RecoveryMonitor
    implements org.neo4j.kernel.recovery.RecoveryMonitor {
        private List<Long> recoveredTransactions = new ArrayList<Long>();
        private int numberOfRecoveredTransactions;

        private RecoveryMonitor() {
        }

        public void recoveryRequired(LogPosition recoveryPosition) {
        }

        public void transactionRecovered(long txId) {
            this.recoveredTransactions.add(txId);
        }

        public void recoveryCompleted(int numberOfRecoveredTransactions) {
            this.numberOfRecoveredTransactions = numberOfRecoveredTransactions;
        }

        int getNumberOfRecoveredTransactions() {
            return this.numberOfRecoveredTransactions;
        }
    }

    private static class CorruptedLogEntryWriter
    extends LogEntryWriter {
        CorruptedLogEntryWriter(FlushableChannel channel) {
            super(channel);
        }

        public void writeStartEntry(int masterId, int authorId, long timeWritten, long latestCommittedTxWhenStarted, byte[] additionalHeaderData) throws IOException {
            this.writeLogEntryHeader((byte)1);
        }
    }
}

