/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionFactory;
import org.neo4j.kernel.api.security.AnonymousContext;

public class TransactionStatementSequenceTest {
    @Test
    public void shouldAllowReadStatementAfterReadStatement() {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((LoginContext)AnonymousContext.read());
        tx.dataRead();
        tx.dataRead();
    }

    @Test
    public void shouldAllowDataStatementAfterReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((LoginContext)AnonymousContext.write());
        tx.dataRead();
        tx.dataWrite();
    }

    @Test
    public void shouldAllowSchemaStatementAfterReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.dataRead();
        tx.schemaWrite();
    }

    @Test
    public void shouldRejectSchemaStatementAfterDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite();
        try {
            tx.schemaWrite();
            Assert.fail((String)"expected exception");
        }
        catch (InvalidTransactionTypeKernelException e) {
            Assert.assertEquals((Object)"Cannot perform schema updates in a transaction that has performed data updates.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldRejectDataStatementAfterSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.schemaWrite();
        try {
            tx.dataWrite();
            Assert.fail((String)"expected exception");
        }
        catch (InvalidTransactionTypeKernelException e) {
            Assert.assertEquals((Object)"Cannot perform data updates in a transaction that has performed schema updates.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldAllowDataStatementAfterDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((LoginContext)AnonymousContext.write());
        tx.dataWrite();
        tx.dataWrite();
    }

    @Test
    public void shouldAllowSchemaStatementAfterSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.schemaWrite();
        tx.schemaWrite();
    }

    @Test
    public void shouldAllowReadStatementAfterDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((LoginContext)AnonymousContext.write());
        tx.dataWrite();
        tx.dataRead();
    }

    @Test
    public void shouldAllowReadStatementAfterSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.schemaWrite();
        tx.dataRead();
    }
}

