/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class CompositeIndexPopulatorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    public CompositeIndexPopulatorCompatibility(IndexProviderCompatibilityTestSuite testSuite, SchemaIndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends CompositeIndexPopulatorCompatibility {
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        Value value3 = Values.of((Object)"value3");
        int nodeId1 = 3;
        int nodeId2 = 4;

        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, SchemaIndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void shouldEnforceUniqueConstraintsDirectly() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            this.withPopulator(this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                p.add(Arrays.asList(IndexEntryUpdate.add((long)this.nodeId1, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{this.value1, this.value2}), IndexEntryUpdate.add((long)this.nodeId2, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{this.value1, this.value2})));
                try {
                    NodePropertyAccessor propertyAccessor = new NodePropertyAccessor(this.nodeId1, this.descriptor.schema(), this.value1, this.value2);
                    propertyAccessor.addNode(this.nodeId2, this.descriptor.schema(), this.value1, this.value2);
                    p.verifyDeferredConstraints((PropertyAccessor)propertyAccessor);
                    Assert.fail((String)"expected exception");
                }
                catch (IndexEntryConflictException conflict) {
                    Assert.assertEquals((long)this.nodeId1, (long)conflict.getExistingNodeId());
                    Assert.assertEquals((Object)ValueTuple.of((Value[])new Value[]{this.value1, this.value2}), (Object)conflict.getPropertyValues());
                    Assert.assertEquals((long)this.nodeId2, (long)conflict.getAddedNodeId());
                }
            }));
        }

        @Test
        public void shouldNotRestrictUpdatesDifferingOnSecondProperty() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            this.withPopulator(this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                p.add(Arrays.asList(IndexEntryUpdate.add((long)this.nodeId1, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{this.value1, this.value2}), IndexEntryUpdate.add((long)this.nodeId2, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{this.value1, this.value3})));
                NodePropertyAccessor propertyAccessor = new NodePropertyAccessor(this.nodeId1, this.descriptor.schema(), this.value1, this.value2);
                propertyAccessor.addNode(this.nodeId2, this.descriptor.schema(), this.value1, this.value3);
                p.verifyDeferredConstraints((PropertyAccessor)propertyAccessor);
            }));
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends CompositeIndexPopulatorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, SchemaIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100, 200}));
        }

        @Test
        public void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            this.withPopulator(this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.add(Arrays.asList(IndexQueryHelper.add(1L, this.descriptor.schema(), "v1", "v2"), IndexQueryHelper.add(2L, this.descriptor.schema(), "v1", "v2")))));
            try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(17L, this.descriptor, indexSamplingConfig);
                 IndexReader reader = accessor.newReader();){
                PrimitiveLongResourceIterator nodes = reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"v1"), IndexQuery.exact((int)1, (Object)"v2")});
                Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)nodes));
            }
        }
    }
}

