/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.MathUtil;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.PlannerInfo;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.locking.LockWaitEvent;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.lock.WaitStrategy;
import org.neo4j.test.FakeCpuClock;
import org.neo4j.test.FakeHeapAllocation;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.VirtualValues;

public class ExecutingQueryTest {
    private final FakeClock clock = Clocks.fakeClock((TemporalAccessor)ZonedDateTime.parse("2016-12-03T15:10:00+01:00"));
    @Rule
    public final FakeCpuClock cpuClock = new FakeCpuClock().add(ExecutingQueryTest.randomLong(0x100000000L));
    @Rule
    public final FakeHeapAllocation heapAllocation = new FakeHeapAllocation().add(ExecutingQueryTest.randomLong(0x100000000L));
    private final PageCursorCountersStub page = new PageCursorCountersStub();
    private long lockCount;
    private ExecutingQuery query = this.createExecutingquery(1, "hello world", this.page, this.clock, this.cpuClock, this.heapAllocation);
    private ExecutingQuery subQuery = this.createExecutingquery(2, "goodbye world", this.page, this.clock, this.cpuClock, this.heapAllocation);

    @Test
    public void shouldReportElapsedTime() {
        this.clock.forward(10L, TimeUnit.SECONDS);
        long elapsedTime = this.query.snapshot().elapsedTimeMillis();
        Assert.assertEquals((long)10000L, (long)elapsedTime);
    }

    @Test
    public void shouldTransitionBetweenStates() {
        Assert.assertEquals((Object)"planning", (Object)this.query.snapshot().status());
        this.query.planningCompleted(new PlannerInfo("the-planner", "the-runtime", Collections.emptyList()));
        Assert.assertEquals((Object)"running", (Object)this.query.snapshot().status());
        try (LockWaitEvent event = this.lock("NODE", 17L);){
            Assert.assertEquals((Object)"waiting", (Object)this.query.snapshot().status());
        }
        Assert.assertEquals((Object)"running", (Object)this.query.snapshot().status());
        this.query.waitsForQuery(this.subQuery);
        Assert.assertEquals((Object)"waiting", (Object)this.query.snapshot().status());
        this.query.waitsForQuery(null);
        Assert.assertEquals((Object)"running", (Object)this.query.snapshot().status());
    }

    @Test
    public void shouldReportPlanningTime() {
        this.clock.forward(124L, TimeUnit.MILLISECONDS);
        QuerySnapshot snapshot = this.query.snapshot();
        Assert.assertEquals((long)snapshot.planningTimeMillis(), (long)snapshot.elapsedTimeMillis());
        this.clock.forward(16L, TimeUnit.MILLISECONDS);
        this.query.planningCompleted(new PlannerInfo("the-planner", "the-runtime", Collections.emptyList()));
        this.clock.forward(200L, TimeUnit.MILLISECONDS);
        snapshot = this.query.snapshot();
        Assert.assertEquals((long)140L, (long)snapshot.planningTimeMillis());
        Assert.assertEquals((long)340L, (long)snapshot.elapsedTimeMillis());
    }

    @Test
    public void shouldReportWaitTime() {
        QuerySnapshot snapshot;
        this.query.planningCompleted(new PlannerInfo("the-planner", "the-runtime", Collections.emptyList()));
        Assert.assertEquals((Object)"running", (Object)this.query.snapshot().status());
        this.clock.forward(10L, TimeUnit.SECONDS);
        try (LockWaitEvent event = this.lock("NODE", 17L);){
            this.clock.forward(5L, TimeUnit.SECONDS);
            snapshot = this.query.snapshot();
            Assert.assertEquals((Object)"waiting", (Object)snapshot.status());
            Assert.assertThat((Object)snapshot.resourceInformation(), (Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Object)"waitTimeMillis", (Object)5000L), (Matcher)Matchers.hasEntry((Object)"resourceType", (Object)"NODE"), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"resourceIds"), ExecutingQueryTest.longArray(17L))));
            Assert.assertEquals((long)5000L, (long)snapshot.waitTimeMillis());
        }
        QuerySnapshot snapshot2 = this.query.snapshot();
        Assert.assertEquals((Object)"running", (Object)snapshot2.status());
        Assert.assertEquals((long)5000L, (long)snapshot2.waitTimeMillis());
        this.clock.forward(2L, TimeUnit.SECONDS);
        event = this.lock("RELATIONSHIP", 612L);
        var2_2 = null;
        try {
            this.clock.forward(1L, TimeUnit.SECONDS);
            snapshot = this.query.snapshot();
            Assert.assertEquals((Object)"waiting", (Object)snapshot.status());
            Assert.assertThat((Object)snapshot.resourceInformation(), (Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Object)"waitTimeMillis", (Object)1000L), (Matcher)Matchers.hasEntry((Object)"resourceType", (Object)"RELATIONSHIP"), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.equalTo((Object)"resourceIds"), ExecutingQueryTest.longArray(612L))));
            Assert.assertEquals((long)6000L, (long)snapshot.waitTimeMillis());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (event != null) {
                if (var2_2 != null) {
                    try {
                        event.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    event.close();
                }
            }
        }
        snapshot2 = this.query.snapshot();
        Assert.assertEquals((Object)"running", (Object)snapshot2.status());
        Assert.assertEquals((long)6000L, (long)snapshot2.waitTimeMillis());
    }

    @Test
    public void shouldReportQueryWaitTime() {
        this.query.planningCompleted(new PlannerInfo("the-planner", "the-runtime", Collections.emptyList()));
        this.query.waitsForQuery(this.subQuery);
        this.clock.forward(5L, TimeUnit.SECONDS);
        QuerySnapshot snapshot = this.query.snapshot();
        Assert.assertEquals((long)5000L, (long)snapshot.waitTimeMillis());
        Assert.assertEquals((Object)"waiting", (Object)snapshot.status());
        Assert.assertThat((Object)snapshot.resourceInformation(), (Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Object)"waitTimeMillis", (Object)5000L), (Matcher)Matchers.hasEntry((Object)"queryId", (Object)"query-2")));
        this.clock.forward(1L, TimeUnit.SECONDS);
        this.query.waitsForQuery(null);
        this.clock.forward(2L, TimeUnit.SECONDS);
        snapshot = this.query.snapshot();
        Assert.assertEquals((long)6000L, (long)snapshot.waitTimeMillis());
        Assert.assertEquals((Object)"running", (Object)snapshot.status());
    }

    @Test
    public void shouldReportCpuTime() {
        this.cpuClock.add(60L, TimeUnit.MILLISECONDS);
        long cpuTime = this.query.snapshot().cpuTimeMillis();
        Assert.assertEquals((long)60L, (long)cpuTime);
    }

    @Test
    public void shouldNotReportCpuTimeIfUnavailable() {
        ExecutingQuery query = new ExecutingQuery(17L, ClientConnectionInfo.EMBEDDED_CONNECTION, "neo4j", "hello world", VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> this.lockCount, (PageCursorCounters)PageCursorTracer.NULL, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)this.clock, FakeCpuClock.NOT_AVAILABLE, HeapAllocation.NOT_AVAILABLE);
        QuerySnapshot snapshot = query.snapshot();
        Assert.assertNull((Object)snapshot.cpuTimeMillis());
        Assert.assertNull((Object)snapshot.idleTimeMillis());
    }

    @Test
    public void shouldReportHeapAllocation() {
        this.heapAllocation.add(4096L);
        long allocatedBytes = this.query.snapshot().allocatedBytes();
        Assert.assertEquals((long)4096L, (long)allocatedBytes);
        this.heapAllocation.add(4096L);
        allocatedBytes = this.query.snapshot().allocatedBytes();
        Assert.assertEquals((long)8192L, (long)allocatedBytes);
    }

    @Test
    public void shouldNotReportHeapAllocationIfUnavailable() {
        ExecutingQuery query = new ExecutingQuery(17L, ClientConnectionInfo.EMBEDDED_CONNECTION, "neo4j", "hello world", VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> this.lockCount, (PageCursorCounters)PageCursorTracer.NULL, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)this.clock, FakeCpuClock.NOT_AVAILABLE, HeapAllocation.NOT_AVAILABLE);
        QuerySnapshot snapshot = query.snapshot();
        Assert.assertNull((Object)snapshot.allocatedBytes());
    }

    @Test
    public void shouldReportLockCount() {
        this.lockCount = 11L;
        Assert.assertEquals((long)11L, (long)this.query.snapshot().activeLockCount());
        this.lockCount = 2L;
        Assert.assertEquals((long)2L, (long)this.query.snapshot().activeLockCount());
    }

    @Test
    public void shouldReportPageHitsAndFaults() {
        this.page.hits(7L);
        this.page.faults(3L);
        QuerySnapshot snapshot = this.query.snapshot();
        Assert.assertEquals((long)7L, (long)snapshot.pageHits());
        Assert.assertEquals((long)3L, (long)snapshot.pageFaults());
        this.page.hits(2L);
        this.page.faults(5L);
        snapshot = this.query.snapshot();
        Assert.assertEquals((long)9L, (long)snapshot.pageHits());
        Assert.assertEquals((long)8L, (long)snapshot.pageFaults());
    }

    @Test
    public void includeQueryExecutorThreadName() {
        String queryDescription = this.query.toString();
        Assert.assertTrue((boolean)queryDescription.contains("threadExecutingTheQueryName=" + Thread.currentThread().getName()));
    }

    private LockWaitEvent lock(String resourceType, long resourceId) {
        return this.query.lockTracer().waitForLock(false, ExecutingQueryTest.resourceType(resourceType), new long[]{resourceId});
    }

    static ResourceType resourceType(final String name) {
        return new ResourceType(){

            public String toString() {
                return this.name();
            }

            public int typeId() {
                throw new UnsupportedOperationException("not used");
            }

            public WaitStrategy waitStrategy() {
                throw new UnsupportedOperationException("not used");
            }

            public String name() {
                return name;
            }
        };
    }

    private static Matcher<Object> longArray(final long ... expected) {
        return new TypeSafeMatcher<long[]>(){

            protected boolean matchesSafely(long[] item) {
                return Arrays.equals(expected, item);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)expected);
            }
        };
    }

    private static long randomLong(long bound) {
        return ThreadLocalRandom.current().nextLong(bound);
    }

    private ExecutingQuery createExecutingquery(int queryId, String hello_world, PageCursorCountersStub page, FakeClock clock, FakeCpuClock cpuClock, FakeHeapAllocation heapAllocation) {
        return new ExecutingQuery((long)queryId, ClientConnectionInfo.EMBEDDED_CONNECTION, "neo4j", hello_world, VirtualValues.EMPTY_MAP, Collections.emptyMap(), () -> this.lockCount, (PageCursorCounters)page, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)clock, (CpuClock)cpuClock, (HeapAllocation)heapAllocation);
    }

    private static class PageCursorCountersStub
    implements PageCursorCounters {
        private long faults;
        private long pins;
        private long unpins;
        private long hits;
        private long bytesRead;
        private long evictions;
        private long evictionExceptions;
        private long bytesWritten;
        private long flushes;

        private PageCursorCountersStub() {
        }

        public long faults() {
            return this.faults;
        }

        public void faults(long increment) {
            this.faults += increment;
        }

        public long pins() {
            return this.pins;
        }

        public void pins(long increment) {
            this.pins += increment;
        }

        public long unpins() {
            return this.unpins;
        }

        public void unpins(long increment) {
            this.unpins += increment;
        }

        public long hits() {
            return this.hits;
        }

        public void hits(long increment) {
            this.hits += increment;
        }

        public long bytesRead() {
            return this.bytesRead;
        }

        public void bytesRead(long increment) {
            this.bytesRead += increment;
        }

        public long evictions() {
            return this.evictions;
        }

        public void evictions(long increment) {
            this.evictions += increment;
        }

        public long evictionExceptions() {
            return this.evictionExceptions;
        }

        public void evictionExceptions(long increment) {
            this.evictionExceptions += increment;
        }

        public long bytesWritten() {
            return this.bytesWritten;
        }

        public void bytesWritten(long increment) {
            this.bytesWritten += increment;
        }

        public long flushes() {
            return this.flushes;
        }

        public void flushes(long increment) {
            this.flushes += increment;
        }

        public double hitRatio() {
            return MathUtil.portion((double[])new double[]{this.hits(), this.faults()});
        }
    }
}

