/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.internal.kernel.api.TokenNameLookup;

public class SchemaTestUtil {
    public static TokenNameLookup simpleNameLookup = new TokenNameLookup(){

        public String labelGetName(int labelId) {
            return "Label" + labelId;
        }

        public String relationshipTypeGetName(int relationshipTypeId) {
            return "RelType" + relationshipTypeId;
        }

        public String propertyKeyGetName(int propertyKeyId) {
            return "property" + propertyKeyId;
        }
    };

    private SchemaTestUtil() {
    }

    public static void assertEquality(Object o1, Object o2) {
        Assert.assertTrue((String)(o1.getClass().getSimpleName() + "s are not equal"), (boolean)o1.equals(o2));
        Assert.assertTrue((String)(o1.getClass().getSimpleName() + "s do not have the same hashcode"), (o1.hashCode() == o2.hashCode() ? 1 : 0) != 0);
    }

    public static void assertArray(int[] values, int ... expected) {
        MatcherAssert.assertThat((Object)values.length, (Matcher)Matchers.equalTo((Object)expected.length));
        for (int i = 0; i < values.length; ++i) {
            Assert.assertTrue((String)String.format("Expected %d, got %d at index %d", expected[i], values[i], i), (values[i] == expected[i] ? 1 : 0) != 0);
        }
    }
}

