/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;

public class SchemaIndexDescriptorFactoryTest {
    private static final int LABEL_ID = 0;

    @Test
    public void shouldCreateIndexDescriptors() {
        SchemaIndexDescriptor desc = SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)SchemaIndexDescriptor.Type.GENERAL));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateUniqueIndexDescriptors() {
        SchemaIndexDescriptor desc = SchemaIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)SchemaIndexDescriptor.Type.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateIndexDescriptorsFromSchema() {
        SchemaIndexDescriptor desc = SchemaIndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)SchemaIndexDescriptor.Type.GENERAL));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
        desc = SchemaIndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)SchemaIndexDescriptor.Type.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateEqualDescriptors() {
        SchemaIndexDescriptor desc1 = SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        SchemaIndexDescriptor desc2 = SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
        desc1 = SchemaIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        desc2 = SchemaIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    public void shouldGiveNiceUserDescriptions() {
        MatcherAssert.assertThat((Object)SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2}).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"Index( GENERAL, :Label1(property2) )"));
        MatcherAssert.assertThat((Object)SchemaIndexDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{4}).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"Index( UNIQUE, :Label2(property4) )"));
    }
}

