/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class KernelTransactionTimeoutMonitorIT {
    @Rule
    public DatabaseRule database = this.createDatabaseRule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final int NODE_ID = 0;
    private ExecutorService executor;

    protected DatabaseRule createDatabaseRule() {
        return new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.transaction_monitor_check_interval, "100ms");
    }

    @Before
    public void setUp() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @After
    public void tearDown() {
        this.executor.shutdown();
    }

    @Test(timeout=30000L)
    public void terminateExpiredTransaction() throws Exception {
        try (Transaction transaction = this.database.beginTx();){
            this.database.createNode();
            transaction.success();
        }
        this.expectedException.expectMessage("The transaction has been terminated.");
        transaction = this.database.beginTx();
        var2_2 = null;
        try {
            Node nodeById = this.database.getNodeById(0L);
            nodeById.setProperty("a", (Object)"b");
            this.executor.submit(this.startAnotherTransaction()).get();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test(timeout=30000L)
    public void terminatingTransactionMustEagerlyReleaseTheirLocks() throws Exception {
        boolean proceed;
        long nodeId;
        AtomicBoolean nodeLockAcquired = new AtomicBoolean();
        AtomicBoolean lockerDone = new AtomicBoolean();
        BinaryLatch lockerPause = new BinaryLatch();
        try (Transaction tx = this.database.beginTx();){
            nodeId = this.database.createNode().getId();
            tx.success();
        }
        Future<?> locker = this.executor.submit(() -> {
            try (Transaction tx = this.database.beginTx();){
                Node node = this.database.getNodeById(nodeId);
                tx.acquireReadLock((PropertyContainer)node);
                nodeLockAcquired.set(true);
                lockerPause.await();
            }
            lockerDone.set(true);
        });
        while (!(proceed = nodeLockAcquired.get())) {
        }
        this.terminateOngoingTransaction();
        Assert.assertFalse((boolean)lockerDone.get());
        try (Transaction tx = this.database.beginTx();){
            tx.acquireWriteLock((PropertyContainer)this.database.getNodeById(nodeId));
            tx.success();
        }
        lockerPause.release();
        locker.get();
        Assert.assertTrue((boolean)lockerDone.get());
    }

    private void terminateOngoingTransaction() {
        Set kernelTransactionHandles = this.database.resolveDependency(KernelTransactions.class).activeTransactions();
        Assert.assertThat((Object)kernelTransactionHandles, (Matcher)Matchers.hasSize((int)1));
        for (KernelTransactionHandle kernelTransactionHandle : kernelTransactionHandles) {
            kernelTransactionHandle.markForTermination((Status)Status.Transaction.Terminated);
        }
    }

    private Runnable startAnotherTransaction() {
        return () -> {
            try (InternalTransaction ignored = this.database.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED, 1L, TimeUnit.SECONDS);){
                Node node = this.database.getNodeById(0L);
                node.setProperty("c", (Object)"d");
            }
        };
    }
}

