/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.KernelTransactionMonitorScheduler;
import org.neo4j.kernel.impl.api.KernelTransactionTimeoutMonitor;
import org.neo4j.scheduler.JobScheduler;

public class KernelTransactionTimeoutMonitorSchedulerTest {
    private final KernelTransactionTimeoutMonitor transactionMonitor = (KernelTransactionTimeoutMonitor)Mockito.mock(KernelTransactionTimeoutMonitor.class);
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);

    @Test
    public void startJobTransactionMonitor() {
        JobScheduler.JobHandle jobHandle = (JobScheduler.JobHandle)Mockito.mock(JobScheduler.JobHandle.class);
        Mockito.when((Object)this.jobScheduler.scheduleRecurring((JobScheduler.Group)ArgumentMatchers.eq((Object)JobScheduler.Groups.transactionTimeoutMonitor), (Runnable)ArgumentMatchers.eq((Object)this.transactionMonitor), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenReturn((Object)jobHandle);
        KernelTransactionMonitorScheduler monitorScheduler = new KernelTransactionMonitorScheduler(this.transactionMonitor, this.jobScheduler, 7L);
        monitorScheduler.start();
        ((JobScheduler)Mockito.verify((Object)this.jobScheduler)).scheduleRecurring(JobScheduler.Groups.transactionTimeoutMonitor, (Runnable)this.transactionMonitor, 7L, TimeUnit.MILLISECONDS);
        monitorScheduler.stop();
        ((JobScheduler.JobHandle)Mockito.verify((Object)jobHandle)).cancel(true);
    }
}

