/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;

public class IndexUpdaterMapTest {
    private IndexMap indexMap;
    private IndexProxy indexProxy1;
    private SchemaIndexDescriptor schemaIndexDescriptor1;
    private IndexUpdater indexUpdater1;
    private IndexProxy indexProxy2;
    private SchemaIndexDescriptor schemaIndexDescriptor2;
    private IndexProxy indexProxy3;
    private SchemaIndexDescriptor schemaIndexDescriptor3;
    private IndexUpdaterMap updaterMap;

    @Before
    public void before() {
        this.indexMap = new IndexMap();
        this.indexProxy1 = (IndexProxy)Mockito.mock(IndexProxy.class);
        this.schemaIndexDescriptor1 = SchemaIndexDescriptorFactory.forLabel((int)2, (int[])new int[]{3});
        this.indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)this.indexProxy1.getDescriptor()).thenReturn((Object)this.schemaIndexDescriptor1);
        Mockito.when((Object)this.indexProxy1.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)this.indexUpdater1);
        this.indexProxy2 = (IndexProxy)Mockito.mock(IndexProxy.class);
        this.schemaIndexDescriptor2 = SchemaIndexDescriptorFactory.forLabel((int)5, (int[])new int[]{6});
        IndexUpdater indexUpdater2 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)this.indexProxy2.getDescriptor()).thenReturn((Object)this.schemaIndexDescriptor2);
        Mockito.when((Object)this.indexProxy2.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)indexUpdater2);
        this.indexProxy3 = (IndexProxy)Mockito.mock(IndexProxy.class);
        this.schemaIndexDescriptor3 = SchemaIndexDescriptorFactory.forLabel((int)5, (int[])new int[]{7, 8});
        IndexUpdater indexUpdater3 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        Mockito.when((Object)this.indexProxy3.getDescriptor()).thenReturn((Object)this.schemaIndexDescriptor3);
        Mockito.when((Object)this.indexProxy3.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class))).thenReturn((Object)indexUpdater3);
        this.updaterMap = new IndexUpdaterMap(this.indexMap, IndexUpdateMode.ONLINE);
    }

    @Test
    public void shouldRetrieveUpdaterFromIndexMapForExistingIndex() {
        this.indexMap.putIndexProxy(0L, this.indexProxy1);
        IndexUpdater updater = this.updaterMap.getUpdater(this.schemaIndexDescriptor1.schema());
        Assert.assertEquals((Object)this.indexUpdater1, (Object)updater);
        Assert.assertEquals((long)1L, (long)this.updaterMap.size());
    }

    @Test
    public void shouldRetrieveUpdateUsingLabelAndProperty() {
        this.indexMap.putIndexProxy(0L, this.indexProxy1);
        IndexUpdater updater = this.updaterMap.getUpdater(this.schemaIndexDescriptor1.schema());
        MatcherAssert.assertThat((Object)updater, (Matcher)Matchers.equalTo((Object)this.indexUpdater1));
    }

    @Test
    public void shouldRetrieveSameUpdaterFromIndexMapForExistingIndexWhenCalledTwice() {
        this.indexMap.putIndexProxy(0L, this.indexProxy1);
        IndexUpdater updater1 = this.updaterMap.getUpdater(this.schemaIndexDescriptor1.schema());
        IndexUpdater updater2 = this.updaterMap.getUpdater(this.schemaIndexDescriptor1.schema());
        Assert.assertEquals((Object)updater1, (Object)updater2);
        Assert.assertEquals((long)1L, (long)this.updaterMap.size());
    }

    @Test
    public void shouldRetrieveNoUpdaterForNonExistingIndex() {
        IndexUpdater updater = this.updaterMap.getUpdater(this.schemaIndexDescriptor1.schema());
        Assert.assertNull((Object)updater);
        Assert.assertTrue((String)"updater map must be empty", (boolean)this.updaterMap.isEmpty());
    }

    @Test
    public void shouldCloseAllUpdaters() throws Exception {
        this.indexMap.putIndexProxy(0L, this.indexProxy1);
        this.indexMap.putIndexProxy(1L, this.indexProxy2);
        IndexUpdater updater1 = this.updaterMap.getUpdater(this.schemaIndexDescriptor1.schema());
        IndexUpdater updater2 = this.updaterMap.getUpdater(this.schemaIndexDescriptor2.schema());
        this.updaterMap.close();
        ((IndexUpdater)Mockito.verify((Object)updater1)).close();
        ((IndexUpdater)Mockito.verify((Object)updater2)).close();
        Assert.assertTrue((String)"updater map must be empty", (boolean)this.updaterMap.isEmpty());
    }
}

