/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.event.ExpectedTransactionData;

public class VerifyingTransactionEventHandler
implements TransactionEventHandler<Object> {
    private final ExpectedTransactionData expectedData;
    private boolean hasBeenCalled;
    private Throwable failure;

    public VerifyingTransactionEventHandler(ExpectedTransactionData expectedData) {
        this.expectedData = expectedData;
    }

    public void afterCommit(TransactionData data, Object state) {
        this.verify(data);
    }

    public void afterRollback(TransactionData data, Object state) {
    }

    public Object beforeCommit(TransactionData data) {
        return this.verify(data);
    }

    private Object verify(TransactionData data) {
        if (Iterables.count((Iterable)data.createdNodes()) == 0L) {
            return null;
        }
        try {
            this.expectedData.compareTo(data);
            this.hasBeenCalled = true;
            return null;
        }
        catch (Exception e) {
            this.failure = e;
            throw e;
        }
    }

    boolean hasBeenCalled() {
        return this.hasBeenCalled;
    }

    Throwable failure() {
        return this.failure;
    }
}

