/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.labelscan.LabelScanStoreTest;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.PageCacheRule;

public class NativeLabelScanStoreTest
extends LabelScanStoreTest {
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();

    @Override
    protected LabelScanStore createLabelScanStore(FileSystemAbstraction fileSystemAbstraction, File rootFolder, FullStoreChangeStream fullStoreChangeStream, boolean usePersistentStore, boolean readOnly, LabelScanStore.Monitor monitor) {
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)monitor, new String[0]);
        return this.getLabelScanStore(fileSystemAbstraction, rootFolder, fullStoreChangeStream, readOnly, monitors);
    }

    private LabelScanStore getLabelScanStore(FileSystemAbstraction fileSystemAbstraction, File rootFolder, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, Monitors monitors) {
        PageCache pageCache = this.pageCacheRule.getPageCache(fileSystemAbstraction);
        return new NativeLabelScanStore(pageCache, fileSystemAbstraction, rootFolder, fullStoreChangeStream, readOnly, monitors, RecoveryCleanupWorkCollector.immediate());
    }

    @Override
    protected Matcher<Iterable<? super String>> hasBareMinimumFileList() {
        return Matchers.hasItem((Matcher)Matchers.equalTo((Object)"neostore.labelscanstore.db"));
    }

    @Override
    protected void corruptIndex(FileSystemAbstraction fileSystem, File rootFolder) throws IOException {
        File lssFile = new File(rootFolder, "neostore.labelscanstore.db");
        this.scrambleFile(lssFile);
    }

    @Test
    public void shutdownNonInitialisedNativeScanStoreWithoutException() throws IOException {
        String expectedMessage = "Expected exception message";
        Monitors monitors = (Monitors)Mockito.mock(Monitors.class);
        Mockito.when((Object)monitors.newMonitor(LabelScanStore.Monitor.class, new String[0])).thenReturn((Object)LabelScanStore.Monitor.EMPTY);
        ((Monitors)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(expectedMessage)}).when((Object)monitors)).addMonitorListener(org.mockito.Matchers.any(), new String[0]);
        LabelScanStore scanStore = this.getLabelScanStore(this.fileSystemRule.get(), this.dir, FullStoreChangeStream.EMPTY, true, monitors);
        try {
            scanStore.init();
            Assert.fail((String)"Initialisation of store should fail.");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
        scanStore.shutdown();
    }

    @Test
    public void shouldStartPopulationAgainIfNotCompletedFirstTime() {
        LifeSupport life = new LifeSupport();
        LabelScanStoreTest.TrackingMonitor monitor = new LabelScanStoreTest.TrackingMonitor();
        life.add((Lifecycle)this.createLabelScanStore(this.fileSystemRule.get(), this.dir, FullStoreChangeStream.EMPTY, true, false, (LabelScanStore.Monitor)monitor));
        life.init();
        Assert.assertTrue((boolean)monitor.noIndexCalled);
        monitor.reset();
        life.shutdown();
        life = new LifeSupport();
        life.add((Lifecycle)this.createLabelScanStore(this.fileSystemRule.get(), this.dir, FullStoreChangeStream.EMPTY, true, false, (LabelScanStore.Monitor)monitor));
        life.init();
        Assert.assertTrue((boolean)monitor.corruptedIndex);
        life.start();
        Assert.assertTrue((boolean)monitor.rebuildingCalled);
        Assert.assertTrue((boolean)monitor.rebuiltCalled);
        life.shutdown();
    }

    @Test
    public void shouldRestartPopulationIfIndexFileWasNeverFullyInitialized() throws IOException {
        File labelScanStoreFile = NativeLabelScanStore.getLabelScanStoreFile((File)this.dir);
        this.fileSystemRule.create(labelScanStoreFile).close();
        LabelScanStoreTest.TrackingMonitor monitor = new LabelScanStoreTest.TrackingMonitor();
        LifeSupport life = new LifeSupport();
        life.add((Lifecycle)this.createLabelScanStore(this.fileSystemRule.get(), this.dir, FullStoreChangeStream.EMPTY, true, false, (LabelScanStore.Monitor)monitor));
        life.start();
        Assert.assertTrue((boolean)monitor.corruptedIndex);
        Assert.assertTrue((boolean)monitor.rebuildingCalled);
        life.shutdown();
    }
}

