/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ConflictDetectingValueMergerTest {
    private final ConflictDetectingValueMerger<NumberSchemaKey, NativeSchemaValue> detector = new ConflictDetectingValueMerger(true);

    @Test
    public void shouldReportConflictOnSameValueAndDifferentEntityIds() {
        Value value = Values.of((Object)123);
        long entityId1 = 10L;
        long entityId2 = 20L;
        NativeSchemaValue merged = this.detector.merge((NativeSchemaKey)ConflictDetectingValueMergerTest.key(entityId1, value), (NativeSchemaKey)ConflictDetectingValueMergerTest.key(entityId2, value), NativeSchemaValue.INSTANCE, NativeSchemaValue.INSTANCE);
        Assert.assertNull((Object)merged);
        try {
            this.detector.checkConflict((Value[])ArrayUtil.array((Object[])new Value[]{value}));
            Assert.fail((String)"Should've detected conflict");
        }
        catch (IndexEntryConflictException e) {
            Assert.assertEquals((long)entityId1, (long)e.getExistingNodeId());
            Assert.assertEquals((long)entityId2, (long)e.getAddedNodeId());
            Assert.assertEquals((Object)value, (Object)e.getSinglePropertyValue());
        }
    }

    @Test
    public void shouldNotReportConflictOnSameValueSameEntityId() throws IndexEntryConflictException {
        Value value = Values.of((Object)123);
        long entityId = 10L;
        NativeSchemaValue merged = this.detector.merge((NativeSchemaKey)ConflictDetectingValueMergerTest.key(entityId, value), (NativeSchemaKey)ConflictDetectingValueMergerTest.key(entityId, value), NativeSchemaValue.INSTANCE, NativeSchemaValue.INSTANCE);
        Assert.assertNull((Object)merged);
        this.detector.checkConflict((Value[])ArrayUtil.array((Object[])new Value[0]));
    }

    private static NumberSchemaKey key(long entityId, Value ... value) {
        NumberSchemaKey key = new NumberSchemaKey();
        key.from(entityId, value);
        return key;
    }
}

