/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeSchemaKey;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DateTimeLayoutTestUtil
extends LayoutTestUtil<ZonedDateTimeSchemaKey, NativeSchemaValue> {
    private static final ZonedDateTime[] ALL_EXTREME_VALUES = new ZonedDateTime[]{ZonedDateTime.of(-999999999, 1, 1, 0, 0, 0, 0, ZoneOffset.ofHours(-18)), ZonedDateTime.of(999999999, 12, 31, 23, 59, 59, 999999999, ZoneOffset.ofHours(18)), ZonedDateTime.of(0, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC), ZonedDateTime.of(0, 1, 1, 0, 0, 0, 0, ZoneOffset.ofHours(-18)), ZonedDateTime.of(0, 1, 1, 0, 0, 0, 0, ZoneOffset.ofHours(18)), ZonedDateTime.of(-1, 12, 31, 23, 59, 59, 999999999, ZoneOffset.UTC)};

    public static DateTimeValue randomDateTime(Randoms random) {
        return DateTimeValue.datetime((ZonedDateTime)random.randomDateTime());
    }

    DateTimeLayoutTestUtil(SchemaIndexDescriptor schemaIndexDescriptor) {
        super(schemaIndexDescriptor);
    }

    @Override
    Layout<ZonedDateTimeSchemaKey, NativeSchemaValue> createLayout() {
        return new ZonedDateTimeLayout();
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates() {
        return this.someUpdatesWithDuplicateValues();
    }

    @Override
    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    @Override
    int compareIndexedPropertyValue(ZonedDateTimeSchemaKey key1, ZonedDateTimeSchemaKey key2) {
        return Values.COMPARATOR.compare(key1.asValue(), key2.asValue());
    }

    @Override
    Value newUniqueValue(RandomRule random, Set<Object> uniqueCompareValues, List<Value> uniqueValues) {
        DateTimeValue candidate;
        while (!uniqueCompareValues.add(candidate = DateTimeLayoutTestUtil.randomDateTime(random.randoms()))) {
        }
        uniqueValues.add((Value)candidate);
        return candidate;
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(ALL_EXTREME_VALUES);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues() {
        return this.generateAddUpdatesFor(ArrayUtils.addAll((Object[])ALL_EXTREME_VALUES, (Object[])ALL_EXTREME_VALUES));
    }
}

