/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.DurationLayout;
import org.neo4j.kernel.impl.index.schema.DurationSchemaKey;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DurationLayoutTestUtil
extends LayoutTestUtil<DurationSchemaKey, NativeSchemaValue> {
    private static final DurationValue[] ALL_EXTREME_VALUES = new DurationValue[]{DurationValue.duration((long)-23999999976L, (long)0L, (long)0L, (long)0L), DurationValue.duration((long)23999999976L, (long)0L, (long)0L, (long)0L), DurationValue.duration((long)0L, (long)-335999999664L, (long)0L, (long)0L), DurationValue.duration((long)0L, (long)335999999664L, (long)0L, (long)0L), DurationValue.duration((long)0L, (long)0L, (long)Long.MIN_VALUE, (long)0L), DurationValue.duration((long)0L, (long)0L, (long)Long.MAX_VALUE, (long)0L), DurationValue.duration((long)0L, (long)0L, (long)0L, (long)Long.MIN_VALUE), DurationValue.duration((long)0L, (long)0L, (long)0L, (long)Long.MAX_VALUE)};

    public static DurationValue randomDuration(Randoms random) {
        return DurationValue.duration((long)0L, (long)0L, (long)random.nextLong(), (long)random.nextLong(-999999999L, 999999999L));
    }

    DurationLayoutTestUtil(SchemaIndexDescriptor schemaIndexDescriptor) {
        super(schemaIndexDescriptor);
    }

    @Override
    Layout<DurationSchemaKey, NativeSchemaValue> createLayout() {
        return new DurationLayout();
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates() {
        return this.someUpdatesWithDuplicateValues();
    }

    @Override
    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    @Override
    int compareIndexedPropertyValue(DurationSchemaKey key1, DurationSchemaKey key2) {
        return Values.COMPARATOR.compare(key1.asValue(), key2.asValue());
    }

    @Override
    Value newUniqueValue(RandomRule random, Set<Object> uniqueCompareValues, List<Value> uniqueValues) {
        DurationValue candidate;
        while (!uniqueCompareValues.add(candidate = DurationLayoutTestUtil.randomDuration(random.randoms()))) {
        }
        uniqueValues.add((Value)candidate);
        return candidate;
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues() {
        return this.generateAddUpdatesFor(ALL_EXTREME_VALUES);
    }

    @Override
    IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues() {
        return this.generateAddUpdatesFor(ArrayUtils.addAll((Object[])ALL_EXTREME_VALUES, (Object[])ALL_EXTREME_VALUES));
    }
}

