/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NumberNonUniqueLayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Values;

public class NumberFullScanNonUniqueIndexSamplerTest
extends NativeSchemaIndexTestUtil<NumberSchemaKey, NativeSchemaValue> {
    @Test
    public void shouldIncludeAllValuesInTree() throws Exception {
        IndexSample sample;
        Object[] values = this.generateNumberValues();
        this.buildTree((Number[])values);
        try (GBPTree gbpTree = this.getTree();){
            IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
            FullScanNonUniqueIndexSampler sampler = new FullScanNonUniqueIndexSampler(gbpTree, this.layout, samplingConfig);
            sample = sampler.result();
        }
        Assert.assertEquals((long)values.length, (long)sample.sampleSize());
        Assert.assertEquals((long)LayoutTestUtil.countUniqueValues(values), (long)sample.uniqueValues());
        Assert.assertEquals((long)values.length, (long)sample.indexSize());
    }

    private Number[] generateNumberValues() {
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        Number[] result = new Number[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            result[i] = (Number)updates[i].values()[0].asObject();
        }
        return result;
    }

    private void buildTree(Number[] values) throws IOException {
        try (GBPTree gbpTree = this.getTree();){
            try (Writer writer = gbpTree.writer();){
                NumberSchemaKey key = (NumberSchemaKey)this.layout.newKey();
                NativeSchemaValue value = (NativeSchemaValue)this.layout.newValue();
                long nodeId = 0L;
                for (Number number : values) {
                    key.from(nodeId, Values.values((Object[])new Object[]{number}));
                    value.from(Values.values((Object[])new Object[]{number}));
                    writer.put((Object)key, (Object)value);
                    ++nodeId;
                }
            }
            gbpTree.checkpoint(IOLimiter.unlimited());
        }
    }

    @Override
    protected LayoutTestUtil<NumberSchemaKey, NativeSchemaValue> createLayoutTestUtil() {
        return new NumberNonUniqueLayoutTestUtil();
    }
}

