/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NativeUniqueSchemaIndexPopulatorTest;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.kernel.impl.index.schema.SpatialLayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.kernel.impl.index.schema.UniqueLayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpatialUniqueSchemaIndexPopulatorTest
extends NativeUniqueSchemaIndexPopulatorTest<SpatialSchemaKey, NativeSchemaValue> {
    private static final CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
    private static final SpaceFillingCurveSettingsFactory settings = new SpaceFillingCurveSettingsFactory(Config.defaults());
    private SpatialIndexFiles.SpatialFile spatialFile;

    @Override
    NativeSchemaIndexPopulator<SpatialSchemaKey, NativeSchemaValue> createPopulator(IndexSamplingConfig samplingConfig) {
        this.spatialFile = new SpatialIndexFiles.SpatialFile(crs, settings, super.getIndexFile());
        return new SpatialIndexPopulator.PartPopulator(this.pageCache, (FileSystemAbstraction)this.fs, this.spatialFile.getLayoutForNewIndex(), this.monitor, this.schemaIndexDescriptor, this.indexId, samplingConfig, (SpaceFillingCurveConfiguration)new StandardConfiguration());
    }

    @Override
    public File getIndexFile() {
        return this.spatialFile.indexFile;
    }

    @Override
    protected LayoutTestUtil<SpatialSchemaKey, NativeSchemaValue> createLayoutTestUtil() {
        return new UniqueLayoutTestUtil<SpatialSchemaKey, NativeSchemaValue>(new SpatialLayoutTestUtil(SchemaIndexDescriptorFactory.uniqueForLabel((int)42, (int[])new int[]{666}), settings.settingsFor(crs), crs));
    }

    @Override
    public void addShouldThrowOnDuplicateValues() {
    }

    @Override
    public void updaterShouldThrowOnDuplicateValues() {
    }
}

