/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

class ReadTestSupport
implements KernelAPIReadTestSupport {
    private final Map<Setting, String> settings = new HashMap<Setting, String>();
    private GraphDatabaseService db;

    ReadTestSupport() {
    }

    void addSetting(Setting setting, String value) {
        this.settings.put(setting, value);
    }

    public void setup(File storeDir, Consumer<GraphDatabaseService> create) {
        GraphDatabaseBuilder graphDatabaseBuilder = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder(storeDir);
        this.settings.forEach((arg_0, arg_1) -> ((GraphDatabaseBuilder)graphDatabaseBuilder).setConfig(arg_0, arg_1));
        this.db = graphDatabaseBuilder.newGraphDatabase();
        create.accept(this.db);
    }

    public Kernel kernelToTest() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.db).getDependencyResolver();
        return (Kernel)resolver.resolveDependency(Kernel.class);
    }

    public void tearDown() {
        this.db.shutdown();
        this.db = null;
    }
}

