/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class TestDynamicStore {
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private StoreFactory storeFactory;
    private NeoStores neoStores;
    private Config config;

    @Before
    public void setUp() {
        File storeDir = new File("dynamicstore");
        ((EphemeralFileSystemAbstraction)this.fs.get()).mkdir(storeDir);
        this.config = this.config();
        this.storeFactory = new StoreFactory(storeDir, this.config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), this.pageCacheRule.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
    }

    @After
    public void tearDown() {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    private DynamicArrayStore createDynamicArrayStore() {
        this.neoStores = this.storeFactory.openAllNeoStores(true);
        return this.neoStores.getPropertyStore().getArrayStore();
    }

    private Config config() {
        return Config.defaults();
    }

    @Test
    public void testClose() {
        DynamicArrayStore store = this.createDynamicArrayStore();
        ArrayList records = new ArrayList();
        store.allocateRecordsFromBytes(records, new byte[10]);
        long blockId = ((DynamicRecord)Iterables.first(records)).getId();
        for (DynamicRecord record : records) {
            store.updateRecord((AbstractBaseRecord)record);
        }
        this.neoStores.close();
        this.neoStores = null;
        try {
            store.getArrayFor((Iterable)store.getRecords(blockId, RecordLoad.NORMAL));
            Assert.fail((String)"Closed store should throw exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            store.getRecords(0L, RecordLoad.NORMAL);
            Assert.fail((String)"Closed store should throw exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testStoreGetCharsFromString() {
        String STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        DynamicArrayStore store = this.createDynamicArrayStore();
        char[] chars = new char["abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length()];
        "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getChars(0, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length(), chars, 0);
        ArrayList records = new ArrayList();
        store.allocateRecords(records, (Object)chars);
        for (DynamicRecord record : records) {
            store.updateRecord((AbstractBaseRecord)record);
        }
    }

    @Test
    public void testRandomTest() {
        Random random = new Random(System.currentTimeMillis());
        DynamicArrayStore store = this.createDynamicArrayStore();
        ArrayList<Long> idsTaken = new ArrayList<Long>();
        HashMap<Long, byte[]> byteData = new HashMap<Long, byte[]>();
        float deleteIndex = 0.2f;
        float closeIndex = 0.1f;
        int currentCount = 0;
        int maxCount = 128;
        HashSet<Long> set = new HashSet<Long>();
        while (currentCount < maxCount) {
            float rIndex = random.nextFloat();
            if (rIndex < deleteIndex && currentCount > 0) {
                long blockId = (Long)idsTaken.remove(random.nextInt(currentCount));
                store.getRecords(blockId, RecordLoad.NORMAL);
                Object bytes = (byte[])store.getArrayFor((Iterable)store.getRecords(blockId, RecordLoad.NORMAL));
                this.validateData((byte[])bytes, (byte[])byteData.remove(blockId));
                Collection records = store.getRecords(blockId, RecordLoad.NORMAL);
                for (DynamicRecord record : records) {
                    record.setInUse(false);
                    store.updateRecord((AbstractBaseRecord)record);
                    set.remove(record.getId());
                }
                --currentCount;
            } else {
                byte[] bytes = this.createRandomBytes(random);
                ArrayList records = new ArrayList();
                store.allocateRecords(records, (Object)bytes);
                for (DynamicRecord record : records) {
                    assert (!set.contains(record.getId()));
                    store.updateRecord((AbstractBaseRecord)record);
                    set.add(record.getId());
                }
                long blockId = ((DynamicRecord)Iterables.first(records)).getId();
                idsTaken.add(blockId);
                byteData.put(blockId, bytes);
                ++currentCount;
            }
            if (!(rIndex > 1.0f - closeIndex) && !(rIndex < closeIndex)) continue;
            this.neoStores.close();
            store = this.createDynamicArrayStore();
        }
    }

    private byte[] createBytes(int length) {
        return new byte[length];
    }

    private byte[] createRandomBytes(Random r) {
        return new byte[r.nextInt(1024)];
    }

    private void validateData(byte[] data1, byte[] data2) {
        Assert.assertEquals((long)data1.length, (long)data2.length);
        for (int i = 0; i < data1.length; ++i) {
            Assert.assertEquals((long)data1[i], (long)data2[i]);
        }
    }

    private long create(DynamicArrayStore store, Object arrayToStore) {
        ArrayList records = new ArrayList();
        store.allocateRecords(records, arrayToStore);
        for (DynamicRecord record : records) {
            store.updateRecord((AbstractBaseRecord)record);
        }
        return ((DynamicRecord)Iterables.first(records)).getId();
    }

    @Test
    public void testAddDeleteSequenceEmptyNumberArray() {
        DynamicArrayStore store = this.createDynamicArrayStore();
        byte[] emptyToWrite = this.createBytes(0);
        long blockId = this.create(store, emptyToWrite);
        store.getRecords(blockId, RecordLoad.NORMAL);
        byte[] bytes = (byte[])store.getArrayFor((Iterable)store.getRecords(blockId, RecordLoad.NORMAL));
        Assert.assertEquals((long)0L, (long)bytes.length);
        Collection records = store.getRecords(blockId, RecordLoad.NORMAL);
        for (DynamicRecord record : records) {
            record.setInUse(false);
            store.updateRecord((AbstractBaseRecord)record);
        }
    }

    @Test
    public void testAddDeleteSequenceEmptyStringArray() {
        DynamicArrayStore store = this.createDynamicArrayStore();
        long blockId = this.create(store, new String[0]);
        store.getRecords(blockId, RecordLoad.NORMAL);
        String[] readBack = (String[])store.getArrayFor((Iterable)store.getRecords(blockId, RecordLoad.NORMAL));
        Assert.assertEquals((long)0L, (long)readBack.length);
        Collection records = store.getRecords(blockId, RecordLoad.NORMAL);
        for (DynamicRecord record : records) {
            record.setInUse(false);
            store.updateRecord((AbstractBaseRecord)record);
        }
    }
}

