/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.id.RenewableBatchIdSequence;

public class RenewableBatchIdSequenceTest {
    public static final int BATCH_SIZE = 5;
    private final IdSource idSource = new IdSource();
    private final List<Long> excessIds = new ArrayList<Long>();
    private final RenewableBatchIdSequence ids = new RenewableBatchIdSequence((IdSequence)this.idSource, 5, this.excessIds::add);

    @Test
    public void shouldRequestIdBatchFromSourceOnFirstCall() {
        Assert.assertEquals((long)0L, (long)this.idSource.calls);
        Assert.assertEquals((long)0L, (long)this.ids.nextId());
        Assert.assertEquals((long)1L, (long)this.idSource.calls);
        for (int i = 1; i < 5; ++i) {
            Assert.assertEquals((long)i, (long)this.ids.nextId());
            Assert.assertEquals((long)1L, (long)this.idSource.calls);
        }
    }

    @Test
    public void shouldRequestIdBatchFromSourceOnDepletingCurrent() {
        Assert.assertEquals((long)0L, (long)this.idSource.calls);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)i, (long)this.ids.nextId());
        }
        Assert.assertEquals((long)1L, (long)this.idSource.calls);
        long firstIdOfNextBatch = this.ids.nextId();
        Assert.assertEquals((long)5L, (long)firstIdOfNextBatch);
        Assert.assertEquals((long)2L, (long)this.idSource.calls);
    }

    @Test
    public void shouldGiveBackExcessIdsOnClose() {
        for (int i = 0; i < 2; ++i) {
            this.ids.nextId();
        }
        this.ids.close();
        Assert.assertEquals((long)3L, (long)this.excessIds.size());
        for (long i = 2L; i < 5L; ++i) {
            Assert.assertTrue((boolean)this.excessIds.contains(i));
        }
    }

    @Test
    public void shouldHandleCloseWithNoCurrentBatch() {
        this.ids.close();
        Assert.assertTrue((boolean)this.excessIds.isEmpty());
    }

    @Test
    public void shouldOnlyCloseOnce() {
        for (int i = 0; i < 2; ++i) {
            this.ids.nextId();
        }
        this.ids.close();
        for (long i = 2L; i < 5L; ++i) {
            Assert.assertTrue((boolean)this.excessIds.remove(i));
        }
        this.ids.close();
        Assert.assertTrue((boolean)this.excessIds.isEmpty());
    }

    @Test
    public void shouldContinueThroughEmptyIdBatch() {
        IdSequence idSource = (IdSequence)Mockito.mock(IdSequence.class);
        Iterator<IdRange> ranges = Arrays.asList(new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, 0L, 5), new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, 5L, 0), new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, 5L, 5)).iterator();
        Mockito.when((Object)idSource.nextIdBatch(ArgumentMatchers.anyInt())).thenAnswer(invocation -> (IdRange)ranges.next());
        RenewableBatchIdSequence ids = new RenewableBatchIdSequence(idSource, 5, this.excessIds::add);
        for (long expectedId = 0L; expectedId < 10L; ++expectedId) {
            Assert.assertEquals((long)expectedId, (long)ids.nextId());
        }
    }

    private static class IdSource
    implements IdSequence {
        int calls;
        long nextId;

        private IdSource() {
        }

        public IdRange nextIdBatch(int batchSize) {
            ++this.calls;
            try {
                IdRange idRange = new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, this.nextId, batchSize);
                return idRange;
            }
            finally {
                this.nextId += (long)batchSize;
            }
        }

        public long nextId() {
            throw new UnsupportedOperationException("Should not be used");
        }
    }
}

