/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.participant.StoreScanChunk;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

public class StoreScanChunkIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void differentChunksHaveDifferentCursors() {
        GraphDatabaseAPI database = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.graphDbDir());
        try {
            RecordStorageEngine recordStorageEngine = (RecordStorageEngine)database.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            NeoStores neoStores = recordStorageEngine.testAccessNeoStores();
            RecordCursor dummyCursor = (RecordCursor)Mockito.mock(RecordCursor.class);
            TestStoreScanChunk scanChunk1 = new TestStoreScanChunk((RecordCursor<NodeRecord>)dummyCursor, neoStores, false);
            TestStoreScanChunk scanChunk2 = new TestStoreScanChunk((RecordCursor<NodeRecord>)dummyCursor, neoStores, false);
            Assert.assertNotSame((Object)scanChunk1.getRecordCursors(), (Object)scanChunk2.getRecordCursors());
            Assert.assertNotSame((Object)scanChunk1.getStorePropertyCursor(), (Object)scanChunk2.getStorePropertyCursor());
        }
        finally {
            database.shutdown();
        }
    }

    private class TestStoreScanChunk
    extends StoreScanChunk<NodeRecord> {
        TestStoreScanChunk(RecordCursor<NodeRecord> cursor, NeoStores neoStores, boolean requiresPropertyMigration) {
            super(cursor, neoStores, requiresPropertyMigration);
        }

        void visitRecord(NodeRecord record, InputEntityVisitor visitor) {
        }

        RecordCursors getRecordCursors() {
            return this.recordCursors;
        }

        StorePropertyCursor getStorePropertyCursor() {
            return this.storePropertyCursor;
        }
    }
}

