/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

@RunWith(value=Parameterized.class)
public class LogPositionTest {
    @Parameterized.Parameter
    public LogPosition logPositionA;
    @Parameterized.Parameter(value=1)
    public LogPosition logPositionB;

    @Parameterized.Parameters
    public static Collection<LogPosition[]> logPositions() {
        return Arrays.asList({new LogPosition(0L, 1L), new LogPosition(0L, 0L)}, {new LogPosition(0L, 11L), new LogPosition(0L, 7L)}, {new LogPosition(2L, 1L), new LogPosition(2L, 0L)}, {new LogPosition(2L, 17L), new LogPosition(2L, 15L)}, {new LogPosition(1L, 1L), new LogPosition(0L, 1L)}, {new LogPosition(5L, 1L), new LogPosition(3L, 10L)}, {new LogPosition(Integer.MAX_VALUE, 0x80000000L), new LogPosition(Integer.MAX_VALUE, Integer.MAX_VALUE)}, {new LogPosition(Long.MAX_VALUE, Long.MAX_VALUE), new LogPosition(0x80000000L, Long.MAX_VALUE)}, {new LogPosition(Long.MAX_VALUE, Long.MAX_VALUE), new LogPosition(Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL)});
    }

    @Test
    public void logPositionComparison() {
        Assert.assertEquals((long)1L, (long)this.logPositionA.compareTo(this.logPositionB));
        Assert.assertEquals((long)-1L, (long)this.logPositionB.compareTo(this.logPositionA));
        Assert.assertEquals((long)0L, (long)this.logPositionA.compareTo(this.logPositionA));
        Assert.assertEquals((long)0L, (long)this.logPositionB.compareTo(this.logPositionB));
    }
}

