/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyLoaderTest {
    private static final int PROP_KEY_ID = 42;
    @Rule
    public final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();
    private final IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
    private final NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private final RelationshipStore relationshipStore = (RelationshipStore)Mockito.mock(RelationshipStore.class);
    private final PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);

    @Before
    public void setUpMocking() {
        ((NeoStores)Mockito.doReturn((Object)this.nodeStore).when((Object)this.neoStores)).getNodeStore();
        Mockito.when((Object)this.nodeStore.newRecord()).thenAnswer(invocation -> new NodeRecord(-1L));
        ((NeoStores)Mockito.doReturn((Object)this.relationshipStore).when((Object)this.neoStores)).getRelationshipStore();
        Mockito.when((Object)this.relationshipStore.newRecord()).thenAnswer(invocation -> new RelationshipRecord(-1L));
        ((NeoStores)Mockito.doReturn((Object)this.propertyStore).when((Object)this.neoStores)).getPropertyStore();
        Mockito.when((Object)this.propertyStore.newRecord()).thenAnswer(invocation -> new PropertyRecord(-1L));
    }

    @Test
    public void shouldThrowForNotInUseNodeRecord() {
        PropertyLoader loader = new PropertyLoader(this.neoStores());
        try {
            loader.nodeLoadProperties(42L, (TransactionRecordState.PropertyReceiver)this.receiver);
        }
        catch (InvalidRecordException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Node"));
        }
    }

    @Test
    public void shouldThrowForNotInUseRelationshipRecord() {
        PropertyLoader loader = new PropertyLoader(this.neoStores());
        try {
            loader.relLoadProperties(42L, (TransactionRecordState.PropertyReceiver)this.receiver);
        }
        catch (InvalidRecordException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Relationship"));
        }
    }

    @Test
    public void shouldReturnCorrectPropertyChainForNode() {
        this.setUpNode(42L, 1, 2, 3);
        PropertyLoader loader = new PropertyLoader(this.neoStores);
        loader.nodeLoadProperties(42L, (TransactionRecordState.PropertyReceiver)this.receiver);
        Assert.assertEquals(Arrays.asList(this.intProperty(42, 1), this.intProperty(42, 2), this.intProperty(42, 3)), (Object)Iterators.asList((Iterator)this.receiver));
    }

    @Test
    public void shouldReturnCorrectPropertyChainForRelationship() {
        this.setUpRelationship(42L, 1111, 2222);
        PropertyLoader loader = new PropertyLoader(this.neoStores);
        loader.relLoadProperties(42L, (TransactionRecordState.PropertyReceiver)this.receiver);
        Assert.assertEquals(Arrays.asList(this.intProperty(42, 1111), this.intProperty(42, 2222)), (Object)Iterators.asList((Iterator)this.receiver));
    }

    private NeoStores neoStores() {
        return ((RecordStorageEngine)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
    }

    private void setUpNode(long id, int ... propertyValues) {
        this.setUpPropertyChain(id, (Class)NodeRecord.class, (CommonAbstractStore)this.nodeStore, propertyValues);
    }

    private void setUpRelationship(long id, int ... propertyValues) {
        this.setUpPropertyChain(id, (Class)RelationshipRecord.class, (CommonAbstractStore)this.relationshipStore, propertyValues);
    }

    private <R extends PrimitiveRecord> void setUpPropertyChain(long id, Class<R> recordClass, CommonAbstractStore<R, ? extends StoreHeader> store, int ... propertyValues) {
        Mockito.when((Object)store.getRecord(ArgumentMatchers.eq((long)id), (AbstractBaseRecord)ArgumentMatchers.any(recordClass), (RecordLoad)ArgumentMatchers.any(RecordLoad.class))).thenAnswer(invocation -> {
            PrimitiveRecord record = (PrimitiveRecord)invocation.getArgument(1);
            record.setId(((Number)invocation.getArgument(0)).longValue());
            record.setNextProp(1L);
            return record;
        });
        ArrayList<PropertyRecord> propertyChain = new ArrayList<PropertyRecord>(propertyValues.length);
        for (int i = 0; i < propertyValues.length; ++i) {
            propertyChain.add(PropertyLoaderTest.newSingleIntProperty(i + 1, propertyValues[i]));
        }
        ((PropertyStore)Mockito.doReturn(propertyChain).when((Object)this.propertyStore)).getPropertyRecordChain(1L);
    }

    private static PropertyRecord newSingleIntProperty(long id, int value) {
        PropertyRecord record = new PropertyRecord(id);
        record.setInUse(true);
        record.addPropertyBlock(PropertyLoaderTest.newSingleIntPropertyBlock(value));
        return record;
    }

    private static PropertyBlock newSingleIntPropertyBlock(int value) {
        PropertyBlock block = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block, (int)42, (Value)Values.intValue((int)value), null, null, (boolean)true);
        block.setKeyIndexId(42);
        return block;
    }

    private StorageProperty intProperty(int propKeyId, int value) {
        return new PropertyKeyValue(propKeyId, Values.of((Object)value));
    }
}

