/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class DepthPitfallGraphTest
extends TraversalTestBase {
    private static final String[] THE_WORLD_AS_WE_KNOW_IT = new String[]{"1 TO 2", "1 TO 3", "1 TO 4", "5 TO 3", "1 TO 5", "4 TO 5", "2 TO 6", "5 TO 6"};
    private static final String[] NODE_UNIQUE_PATHS = new String[]{"1", "1,2", "1,2,6", "1,2,6,5", "1,2,6,5,3", "1,2,6,5,4", "1,3", "1,3,5", "1,3,5,4", "1,3,5,6", "1,3,5,6,2", "1,4", "1,4,5", "1,4,5,3", "1,4,5,6", "1,4,5,6,2", "1,5", "1,5,3", "1,5,4", "1,5,6", "1,5,6,2"};
    private static final String[] RELATIONSHIP_UNIQUE_EXTRA_PATHS = new String[]{"1,2,6,5,1", "1,2,6,5,1,3", "1,2,6,5,1,3,5", "1,2,6,5,1,3,5,4", "1,2,6,5,1,3,5,4,1", "1,2,6,5,1,4", "1,2,6,5,1,4,5", "1,2,6,5,1,4,5,3", "1,2,6,5,1,4,5,3,1", "1,2,6,5,3,1", "1,2,6,5,3,1,4", "1,2,6,5,3,1,4,5", "1,2,6,5,3,1,4,5,1", "1,2,6,5,3,1,5", "1,2,6,5,3,1,5,4", "1,2,6,5,3,1,5,4,1", "1,2,6,5,4,1", "1,2,6,5,4,1,3", "1,2,6,5,4,1,3,5", "1,2,6,5,4,1,3,5,1", "1,2,6,5,4,1,5", "1,2,6,5,4,1,5,3", "1,2,6,5,4,1,5,3,1", "1,3,5,1", "1,3,5,1,2", "1,3,5,1,2,6", "1,3,5,1,2,6,5", "1,3,5,1,2,6,5,4", "1,3,5,1,2,6,5,4,1", "1,3,5,1,4", "1,3,5,1,4,5", "1,3,5,1,4,5,6", "1,3,5,1,4,5,6,2", "1,3,5,1,4,5,6,2,1", "1,3,5,4,1", "1,3,5,4,1,2", "1,3,5,4,1,2,6", "1,3,5,4,1,2,6,5", "1,3,5,4,1,2,6,5,1", "1,3,5,4,1,5", "1,3,5,4,1,5,6", "1,3,5,4,1,5,6,2", "1,3,5,4,1,5,6,2,1", "1,3,5,6,2,1", "1,3,5,6,2,1,4", "1,3,5,6,2,1,4,5", "1,3,5,6,2,1,4,5,1", "1,3,5,6,2,1,5", "1,3,5,6,2,1,5,4", "1,3,5,6,2,1,5,4,1", "1,4,5,1", "1,4,5,1,2", "1,4,5,1,2,6", "1,4,5,1,2,6,5", "1,4,5,1,2,6,5,3", "1,4,5,1,2,6,5,3,1", "1,4,5,1,3", "1,4,5,1,3,5", "1,4,5,1,3,5,6", "1,4,5,1,3,5,6,2", "1,4,5,1,3,5,6,2,1", "1,4,5,3,1", "1,4,5,3,1,2", "1,4,5,3,1,2,6", "1,4,5,3,1,2,6,5", "1,4,5,3,1,2,6,5,1", "1,4,5,3,1,5", "1,4,5,3,1,5,6", "1,4,5,3,1,5,6,2", "1,4,5,3,1,5,6,2,1", "1,4,5,6,2,1", "1,4,5,6,2,1,3", "1,4,5,6,2,1,3,5", "1,4,5,6,2,1,3,5,1", "1,4,5,6,2,1,5", "1,4,5,6,2,1,5,3", "1,4,5,6,2,1,5,3,1", "1,5,3,1", "1,5,3,1,2", "1,5,3,1,2,6", "1,5,3,1,2,6,5", "1,5,3,1,2,6,5,4", "1,5,3,1,2,6,5,4,1", "1,5,3,1,4", "1,5,3,1,4,5", "1,5,3,1,4,5,6", "1,5,3,1,4,5,6,2", "1,5,3,1,4,5,6,2,1", "1,5,4,1", "1,5,4,1,2", "1,5,4,1,2,6", "1,5,4,1,2,6,5", "1,5,4,1,2,6,5,3", "1,5,4,1,2,6,5,3,1", "1,5,4,1,3", "1,5,4,1,3,5", "1,5,4,1,3,5,6", "1,5,4,1,3,5,6,2", "1,5,4,1,3,5,6,2,1", "1,5,6,2,1", "1,5,6,2,1,3", "1,5,6,2,1,3,5", "1,5,6,2,1,3,5,4", "1,5,6,2,1,3,5,4,1", "1,5,6,2,1,4", "1,5,6,2,1,4,5", "1,5,6,2,1,4,5,3", "1,5,6,2,1,4,5,3,1"};

    @Before
    public void setup() {
        this.createGraph(THE_WORLD_AS_WE_KNOW_IT);
    }

    @Test
    public void testSmallestPossibleInit() {
        Traverser traversal = this.getGraphDb().traversalDescription().traverse(this.node("1"));
        int count = 0;
        try (Transaction transaction = this.beginTx();){
            for (Path position : traversal) {
                ++count;
                Assert.assertNotNull((Object)position);
                Assert.assertNotNull((Object)position.endNode());
                if (position.length() <= 0) continue;
                Assert.assertNotNull((Object)position.lastRelationship());
            }
            Assert.assertFalse((String)"empty traversal", (count == 0 ? 1 : 0) != 0);
            transaction.success();
        }
    }

    @Test
    public void testAllNodesAreReturnedOnceDepthFirst() {
        this.testAllNodesAreReturnedOnce(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void testAllNodesAreReturnedOnceBreadthFirst() {
        this.testAllNodesAreReturnedOnce(this.getGraphDb().traversalDescription().breadthFirst());
    }

    private void testAllNodesAreReturnedOnce(TraversalDescription traversal) {
        Traverser traverser = traversal.uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL).traverse(this.node("1"));
        this.expectNodes(traverser, "1", "2", "3", "4", "5", "6");
    }

    @Test
    public void testNodesAreReturnedOnceWhenSufficientRecentlyUniqueDepthFirst() {
        this.testNodesAreReturnedOnceWhenSufficientRecentlyUnique(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void testNodesAreReturnedOnceWhenSufficientRecentlyUniqueBreadthFirst() {
        this.testNodesAreReturnedOnceWhenSufficientRecentlyUnique(this.getGraphDb().traversalDescription().breadthFirst());
    }

    private void testNodesAreReturnedOnceWhenSufficientRecentlyUnique(TraversalDescription description) {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.NODE_RECENT, (Object)6).traverse(this.node("1"));
        this.expectNodes(traverser, "1", "2", "3", "4", "5", "6");
    }

    @Test
    public void testAllRelationshipsAreReturnedOnceDepthFirst() {
        this.testAllRelationshipsAreReturnedOnce(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void testAllRelationshipsAreReturnedOnceBreadthFirst() {
        this.testAllRelationshipsAreReturnedOnce(this.getGraphDb().traversalDescription().breadthFirst());
    }

    private void testAllRelationshipsAreReturnedOnce(TraversalDescription description) {
        Traverser traverser = this.getGraphDb().traversalDescription().uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL).traverse(this.node("1"));
        this.expectRelationships(traverser, THE_WORLD_AS_WE_KNOW_IT);
    }

    @Test
    public void testRelationshipsAreReturnedOnceWhenSufficientRecentlyUniqueDepthFirst() {
        this.testRelationshipsAreReturnedOnceWhenSufficientRecentlyUnique(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void testRelationshipsAreReturnedOnceWhenSufficientRecentlyUniqueBreadthFirst() {
        this.testRelationshipsAreReturnedOnceWhenSufficientRecentlyUnique(this.getGraphDb().traversalDescription().breadthFirst());
    }

    private void testRelationshipsAreReturnedOnceWhenSufficientRecentlyUnique(TraversalDescription description) {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_RECENT, (Object)THE_WORLD_AS_WE_KNOW_IT.length).traverse(this.node("1"));
        this.expectRelationships(traverser, THE_WORLD_AS_WE_KNOW_IT);
    }

    @Test
    public void testAllUniqueNodePathsAreReturnedDepthFirst() {
        this.testAllUniqueNodePathsAreReturned(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void testAllUniqueNodePathsAreReturnedBreadthFirst() {
        this.testAllUniqueNodePathsAreReturned(this.getGraphDb().traversalDescription().breadthFirst());
    }

    private void testAllUniqueNodePathsAreReturned(TraversalDescription description) {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).traverse(this.node("1"));
        this.expectPaths(traverser, NODE_UNIQUE_PATHS);
    }

    @Test
    public void testAllUniqueRelationshipPathsAreReturnedDepthFirst() {
        this.testAllUniqueRelationshipPathsAreReturned(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void testAllUniqueRelationshipPathsAreReturnedBreadthFirst() {
        this.testAllUniqueRelationshipPathsAreReturned(this.getGraphDb().traversalDescription().breadthFirst());
    }

    private void testAllUniqueRelationshipPathsAreReturned(TraversalDescription description) {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(NODE_UNIQUE_PATHS));
        expected.addAll(Arrays.asList(RELATIONSHIP_UNIQUE_EXTRA_PATHS));
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_PATH).traverse(this.node("1"));
        this.expectPaths(traverser, expected);
    }

    @Test
    public void canPruneTraversalAtSpecificDepthDepthFirst() {
        this.canPruneTraversalAtSpecificDepth(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void canPruneTraversalAtSpecificDepthBreadthFirst() {
        this.canPruneTraversalAtSpecificDepth(this.getGraphDb().traversalDescription().breadthFirst());
    }

    private void canPruneTraversalAtSpecificDepth(TraversalDescription description) {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.NONE).evaluator(Evaluators.toDepth((int)1)).traverse(this.node("1"));
        this.expectNodes(traverser, "1", "2", "3", "4", "5");
    }

    @Test
    public void canPreFilterNodesDepthFirst() {
        this.canPreFilterNodes(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void canPreFilterNodesBreadthFirst() {
        this.canPreFilterNodes(this.getGraphDb().traversalDescription().breadthFirst());
    }

    private void canPreFilterNodes(TraversalDescription description) {
        Traverser traverser = description.uniqueness((UniquenessFactory)Uniqueness.NONE).evaluator(Evaluators.atDepth((int)2)).traverse(this.node("1"));
        this.expectPaths(traverser, "1,2,6", "1,3,5", "1,4,5", "1,5,3", "1,5,4", "1,5,6");
    }
}

