/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.time.Clock;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.kernel.impl.util.CappedLogger;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

@RunWith(value=Parameterized.class)
public class CappedLoggerTest {
    private final String logName;
    private final LogMethod logMethod;
    private AssertableLogProvider logProvider;
    private CappedLogger logger;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> parameters() {
        LogMethod debug = new LogMethod(){

            @Override
            public void log(@Nonnull CappedLogger logger, @Nonnull String msg) {
                logger.debug(msg);
            }

            @Override
            public void log(@Nonnull CappedLogger logger, @Nonnull String msg, @Nonnull Throwable cause) {
                logger.debug(msg, cause);
            }
        };
        LogMethod info = new LogMethod(){

            @Override
            public void log(@Nonnull CappedLogger logger, @Nonnull String msg) {
                logger.debug(msg);
            }

            @Override
            public void log(@Nonnull CappedLogger logger, @Nonnull String msg, @Nonnull Throwable cause) {
                logger.info(msg, cause);
            }
        };
        LogMethod warn = new LogMethod(){

            @Override
            public void log(@Nonnull CappedLogger logger, @Nonnull String msg) {
                logger.debug(msg);
            }

            @Override
            public void log(@Nonnull CappedLogger logger, @Nonnull String msg, @Nonnull Throwable cause) {
                logger.warn(msg, cause);
            }
        };
        LogMethod error = new LogMethod(){

            @Override
            public void log(@Nonnull CappedLogger logger, @Nonnull String msg) {
                logger.debug(msg);
            }

            @Override
            public void log(@Nonnull CappedLogger logger, @Nonnull String msg, @Nonnull Throwable cause) {
                logger.error(msg, cause);
            }
        };
        return Arrays.asList({"debug", debug}, {"info", info}, {"warn", warn}, {"error", error});
    }

    public CappedLoggerTest(String logName, LogMethod logMethod) {
        this.logName = logName;
        this.logMethod = logMethod;
    }

    public String[] logLines(int lineCount) {
        return this.logLines(lineCount, 0);
    }

    public String[] logLines(int lineCount, int startAt) {
        String[] lines = new String[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            String msg;
            lines[i] = msg = String.format("### %04d ###", startAt + i);
            this.logMethod.log(this.logger, msg);
        }
        return lines;
    }

    public void assertLoggedLines(String[] lines, int count) {
        this.assertLoggedLines(lines, count, 0);
    }

    public void assertLoggedLines(String[] lines, int count, int skip) {
        int i;
        Matcher[] matchers = new Matcher[count];
        for (i = 0; i < skip; ++i) {
            matchers[i] = Matchers.any(String.class);
        }
        while (i < count) {
            String line = lines[i];
            matchers[i] = Matchers.containsString((String)line);
            ++i;
        }
        this.logProvider.assertContainsLogCallsMatching(skip, matchers);
    }

    @Before
    public void setUp() {
        this.logProvider = new AssertableLogProvider();
        this.logger = new CappedLogger(this.logProvider.getLog(CappedLogger.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowIfDelegateIsNull() {
        new CappedLogger(null);
    }

    @Test
    public void mustLogWithoutLimitConfiguration() {
        int lineCount = 1000;
        String[] lines = this.logLines(lineCount);
        this.assertLoggedLines(lines, lineCount);
    }

    @Test
    public void mustLogExceptions() {
        this.logMethod.log(this.logger, "MESSAGE", new ArithmeticException("EXCEPTION"));
        this.logProvider.assertContainsLogCallContaining("MESSAGE");
        this.logProvider.assertContainsLogCallContaining("ArithmeticException");
        this.logProvider.assertContainsLogCallContaining("EXCEPTION");
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowOnSettingZeroCountLimit() {
        this.logger.setCountLimit(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowOnSettingNegativeCountLimit() {
        this.logger.setCountLimit(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowOnZeroTimeLimit() {
        this.logger.setTimeLimit(0L, TimeUnit.MILLISECONDS, Clocks.systemClock());
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowOnNegativeTimeLimit() {
        this.logger.setTimeLimit(-1L, TimeUnit.MILLISECONDS, Clocks.systemClock());
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowOnNullTimeUnit() {
        this.logger.setTimeLimit(10L, null, Clocks.systemClock());
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowOnNullClock() {
        this.logger.setTimeLimit(10L, TimeUnit.MILLISECONDS, null);
    }

    @Test
    public void mustAllowConfigurationChaining() {
        this.logger.setCountLimit(1).setTimeLimit(10L, TimeUnit.MILLISECONDS, Clocks.systemClock()).setDuplicateFilterEnabled(true).unsetCountLimit().unsetTimeLimit().setCountLimit(1);
    }

    @Test
    public void mustLimitByConfiguredCount() {
        int limit = 10;
        this.logger.setCountLimit(limit);
        String[] lines = this.logLines(limit + 1);
        this.assertLoggedLines(lines, limit);
        this.logProvider.assertNone(this.currentLog(AssertableLogProvider.inLog(CappedLogger.class), (Matcher<String>)Matchers.containsString((String)lines[limit])));
    }

    @Test
    public void mustLogAfterResetWithCountLimit() {
        int limit = 10;
        this.logger.setCountLimit(limit);
        Object[] lines = this.logLines(limit + 1);
        this.logger.reset();
        Object[] moreLines = this.logLines(1, limit + 1);
        this.assertLoggedLines((String[])ArrayUtils.addAll((Object[])ArrayUtils.subarray((Object[])lines, (int)0, (int)limit), (Object[])moreLines), 1 + limit);
        this.logProvider.assertNone(this.currentLog(AssertableLogProvider.inLog(CappedLogger.class), (Matcher<String>)Matchers.containsString((String)lines[limit])));
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)moreLines[0]));
    }

    @Test
    public void unsettingCountLimitMustLetMessagesThrough() {
        int limit = 10;
        this.logger.setCountLimit(limit);
        Object[] lines = this.logLines(limit + 1);
        this.logger.unsetCountLimit();
        int moreLineCount = 1000;
        Object[] moreLines = this.logLines(moreLineCount, limit + 1);
        this.assertLoggedLines((String[])ArrayUtils.addAll((Object[])ArrayUtils.subarray((Object[])lines, (int)0, (int)limit), (Object[])moreLines), moreLineCount + limit);
        this.logProvider.assertNone(this.currentLog(AssertableLogProvider.inLog(CappedLogger.class), (Matcher<String>)Matchers.containsString((String)lines[limit])));
        this.assertLoggedLines((String[])moreLines, moreLineCount, limit);
    }

    @Test
    public void mustNotLogMessagesWithinConfiguredTimeLimit() {
        FakeClock clock = this.getDefaultFakeClock();
        this.logger.setTimeLimit(1L, TimeUnit.MILLISECONDS, (Clock)clock);
        this.logMethod.log(this.logger, "### AAA ###");
        this.logMethod.log(this.logger, "### BBB ###");
        clock.forward(1L, TimeUnit.MILLISECONDS);
        this.logMethod.log(this.logger, "### CCC ###");
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)"### AAA ###"));
        this.logProvider.assertNone(this.currentLog(AssertableLogProvider.inLog(CappedLogger.class), (Matcher<String>)Matchers.containsString((String)"### BBB ###")));
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)"### CCC ###"));
    }

    @Test
    public void unsettingTimeLimitMustLetMessagesThrough() {
        FakeClock clock = this.getDefaultFakeClock();
        this.logger.setTimeLimit(1L, TimeUnit.MILLISECONDS, (Clock)clock);
        this.logMethod.log(this.logger, "### AAA ###");
        this.logMethod.log(this.logger, "### BBB ###");
        clock.forward(1L, TimeUnit.MILLISECONDS);
        this.logMethod.log(this.logger, "### CCC ###");
        this.logMethod.log(this.logger, "### DDD ###");
        this.logger.unsetTimeLimit();
        this.logMethod.log(this.logger, "### EEE ###");
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)"### AAA ###"));
        this.logProvider.assertNone(this.currentLog(AssertableLogProvider.inLog(CappedLogger.class), (Matcher<String>)Matchers.containsString((String)"### BBB ###")));
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)"### CCC ###"));
        this.logProvider.assertNone(this.currentLog(AssertableLogProvider.inLog(CappedLogger.class), (Matcher<String>)Matchers.containsString((String)"### DDD ###")));
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)"### EEE ###"));
    }

    @Test
    public void mustLogAfterResetWithTimeLimit() {
        FakeClock clock = this.getDefaultFakeClock();
        this.logger.setTimeLimit(1L, TimeUnit.MILLISECONDS, (Clock)clock);
        this.logMethod.log(this.logger, "### AAA ###");
        this.logMethod.log(this.logger, "### BBB ###");
        this.logger.reset();
        this.logMethod.log(this.logger, "### CCC ###");
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)"### AAA ###"));
        this.logProvider.assertNone(this.currentLog(AssertableLogProvider.inLog(CappedLogger.class), (Matcher<String>)Matchers.containsString((String)"### BBB ###")));
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)"### CCC ###"));
    }

    @Test
    public void mustOnlyLogMessagesThatPassBothLimits() {
        FakeClock clock = this.getDefaultFakeClock();
        this.logger.setCountLimit(2);
        this.logger.setTimeLimit(1L, TimeUnit.MILLISECONDS, (Clock)clock);
        this.logMethod.log(this.logger, "### AAA ###");
        this.logMethod.log(this.logger, "### BBB ###");
        clock.forward(1L, TimeUnit.MILLISECONDS);
        this.logMethod.log(this.logger, "### CCC ###");
        this.logger.reset();
        this.logMethod.log(this.logger, "### DDD ###");
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)"### AAA ###"));
        this.logProvider.assertNone(this.currentLog(AssertableLogProvider.inLog(CappedLogger.class), (Matcher<String>)Matchers.containsString((String)"### BBB ###")));
        this.logProvider.assertNone(this.currentLog(AssertableLogProvider.inLog(CappedLogger.class), (Matcher<String>)Matchers.containsString((String)"### CCC ###")));
        this.logProvider.assertContainsMessageMatching(Matchers.containsString((String)"### DDD ###"));
    }

    @Test
    public void mustFilterDuplicateMessageAndNullException() {
        this.logger.setDuplicateFilterEnabled(true);
        this.logMethod.log(this.logger, "### AAA ###");
        this.logMethod.log(this.logger, "### AAA ###");
        this.logMethod.log(this.logger, "### BBB ###");
        String[] lines = new String[]{"### AAA ###", "### BBB ###"};
        this.assertLoggedLines(lines, lines.length);
    }

    @Test
    public void mustFilterDuplicateMessageAndException() {
        this.logger.setDuplicateFilterEnabled(true);
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace("exc_aaa"));
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace("exc_aaa"));
        this.logMethod.log(this.logger, "### BBB ###", new ExceptionWithoutStackTrace("exc_bbb"));
        String[] messages = new String[]{"### AAA ###", "### BBB ###"};
        this.assertLoggedLines(messages, messages.length);
    }

    @Test
    public void mustLogSameMessageAndDifferentExceptionWithDuplicateLimit() {
        this.logger.setDuplicateFilterEnabled(true);
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace("exc_aaa"));
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace("exc_bbb"));
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace2("exc_bbb"));
        String[] messages = new String[]{"### AAA ###", "### AAA ###", "### AAA ###"};
        this.assertLoggedLines(messages, messages.length);
    }

    @Test
    public void mustLogSameMessageAndNonNullExceptionWithDuplicateLimit() {
        this.logger.setDuplicateFilterEnabled(true);
        this.logMethod.log(this.logger, "### AAA ###");
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace(null));
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace2(null));
        String[] messages = new String[]{"### AAA ###", "### AAA ###", "### AAA ###"};
        this.assertLoggedLines(messages, messages.length);
    }

    @Test
    public void mustFilterSameMessageAndExceptionWithNullMessage() {
        this.logger.setDuplicateFilterEnabled(true);
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace(null));
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace(null));
        this.logMethod.log(this.logger, "### BBB ###");
        String[] messages = new String[]{"### AAA ###", "### BBB ###"};
        this.assertLoggedLines(messages, messages.length);
    }

    @Test
    public void mustLogDifferentMessageAndSameExceptionWithDuplicateLimit() {
        this.logger.setDuplicateFilterEnabled(true);
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace("xyz"));
        this.logMethod.log(this.logger, "### BBB ###", new ExceptionWithoutStackTrace("xyz"));
        String[] messages = new String[]{"### AAA ###", "### BBB ###"};
        this.assertLoggedLines(messages, messages.length);
    }

    @Test
    public void mustLogDifferentMessageAndDifferentExceptionWithDuplicateLimit() {
        this.logger.setDuplicateFilterEnabled(true);
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace("foo"));
        this.logMethod.log(this.logger, "### BBB ###", new ExceptionWithoutStackTrace("bar"));
        String[] messages = new String[]{"### AAA ###", "### BBB ###"};
        this.assertLoggedLines(messages, messages.length);
    }

    @Test
    public void mustLogSameMessageAndExceptionAfterResetWithDuplicateFilter() {
        this.logger.setDuplicateFilterEnabled(true);
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace("xyz"));
        this.logger.reset();
        this.logMethod.log(this.logger, "### AAA ###", new ExceptionWithoutStackTrace("xyz"));
        String[] messages = new String[]{"### AAA ###", "### AAA ###"};
        this.assertLoggedLines(messages, messages.length);
    }

    private AssertableLogProvider.LogMatcher currentLog(AssertableLogProvider.LogMatcherBuilder logMatcherBuilder, Matcher<String> stringMatcher) {
        switch (this.logName) {
            case "debug": {
                return logMatcherBuilder.debug(stringMatcher);
            }
            case "info": {
                return logMatcherBuilder.info(stringMatcher);
            }
            case "warn": {
                return logMatcherBuilder.warn(stringMatcher);
            }
            case "error": {
                return logMatcherBuilder.error(stringMatcher);
            }
        }
        throw new RuntimeException("Unknown log name");
    }

    private FakeClock getDefaultFakeClock() {
        return Clocks.fakeClock((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static class ExceptionWithoutStackTrace2
    extends Exception {
        ExceptionWithoutStackTrace2(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class ExceptionWithoutStackTrace
    extends Exception {
        ExceptionWithoutStackTrace(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static interface LogMethod {
        public void log(@Nonnull CappedLogger var1, @Nonnull String var2);

        public void log(@Nonnull CappedLogger var1, @Nonnull String var2, @Nonnull Throwable var3);
    }
}

