/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.NumberAwareStringComparator;

public class NumberAwareStringComparatorTest {
    @Test
    public void shouldHandleSingleNumber() {
        this.assertLesser("123", "456");
        this.assertLesser("123", "1234");
        this.assertLesser("1", "12");
        this.assertSame("123", "123");
        this.assertSame("001", "1");
        this.assertGreater("555", "66");
    }

    @Test
    public void shouldHandleMixedAlthoughSimilarNumbersAndStrings() {
        this.assertLesser("same-1-thing-45", "same-12-thing-45");
        this.assertGreater("same-2-thing-46", "same-2-thing-45");
    }

    @Test
    public void shouldHandleMixedAndDifferentNumbersAndStrings() {
        this.assertLesser("same123thing456", "same123thing456andmore");
        this.assertGreater("same12", "same1thing456andmore");
    }

    private void assertLesser(String first, String other) {
        Assert.assertTrue((this.compare(first, other) < 0 ? 1 : 0) != 0);
    }

    private void assertSame(String first, String other) {
        Assert.assertEquals((long)0L, (long)this.compare(first, other));
    }

    private void assertGreater(String first, String other) {
        Assert.assertTrue((this.compare(first, other) > 0 ? 1 : 0) != 0);
    }

    private int compare(String first, String other) {
        return new NumberAwareStringComparator().compare(first, other);
    }
}

