/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.JobScheduler;

public class OnDemandJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private List<Runnable> jobs = new CopyOnWriteArrayList<Runnable>();
    private final boolean removeJobsAfterExecution;

    public OnDemandJobScheduler() {
        this(true);
    }

    public OnDemandJobScheduler(boolean removeJobsAfterExecution) {
        this.removeJobsAfterExecution = removeJobsAfterExecution;
    }

    public void setTopLevelGroupName(String name) {
    }

    public Executor executor(JobScheduler.Group group) {
        return command -> this.jobs.add(command);
    }

    public ThreadFactory threadFactory(JobScheduler.Group group) {
        throw new UnsupportedOperationException();
    }

    public ExecutorService workStealingExecutor(JobScheduler.Group group, int parallelism) {
        throw new UnsupportedOperationException();
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
        this.jobs.add(job);
        return new OnDemandJobHandle();
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job, long initialDelay, TimeUnit timeUnit) {
        this.jobs.add(job);
        return new OnDemandJobHandle();
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        this.jobs.add(runnable);
        return new OnDemandJobHandle();
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.jobs.add(runnable);
        return new OnDemandJobHandle();
    }

    public Runnable getJob() {
        return this.jobs.size() > 0 ? this.jobs.get(0) : null;
    }

    public void runJob() {
        for (Runnable job : this.jobs) {
            job.run();
            if (!this.removeJobsAfterExecution) continue;
            this.jobs.remove(job);
        }
    }

    private class OnDemandJobHandle
    implements JobScheduler.JobHandle {
        private OnDemandJobHandle() {
        }

        public void cancel(boolean mayInterruptIfRunning) {
            OnDemandJobScheduler.this.jobs.clear();
        }

        public void waitTermination() {
        }
    }
}

