/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mockito.matcher;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class RootCauseMatcher<T extends Throwable>
extends TypeSafeMatcher<T> {
    private final Class<T> rootCause;
    private final String message;
    private Throwable cause;

    public RootCauseMatcher(Class<T> rootCause) {
        this(rootCause, "");
    }

    public RootCauseMatcher(Class<T> rootCause, String message) {
        this.rootCause = rootCause;
        this.message = message;
    }

    protected boolean matchesSafely(T item) {
        this.cause = ExceptionUtils.getRootCause(item);
        return this.rootCause.isInstance(this.cause) && this.cause.getMessage().startsWith(this.message);
    }

    public void describeTo(Description description) {
        description.appendText("Expected root cause of ").appendValue(this.rootCause).appendText(" with message: ").appendValue((Object)this.message).appendText(", but ");
        if (this.cause != null) {
            description.appendText("was: ").appendValue(this.cause.getClass()).appendText(" with message: ").appendValue((Object)this.cause.getMessage());
        } else {
            description.appendText("actual exception was never thrown.");
        }
    }
}

