/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.OutputStream;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.test.rule.PageCacheRule;

public class ConfigurablePageCacheRule
extends PageCacheRule {
    public PageCache getPageCache(FileSystemAbstraction fs, Config config) {
        return this.getPageCache(fs, ConfigurablePageCacheRule.config(), config);
    }

    public PageCache getPageCache(FileSystemAbstraction fs, PageCacheRule.PageCacheConfig pageCacheConfig, Config config) {
        this.closeExistingPageCache();
        this.pageCache = this.createPageCache(fs, pageCacheConfig, config);
        this.pageCachePostConstruct(pageCacheConfig);
        return this.pageCache;
    }

    private PageCache createPageCache(FileSystemAbstraction fs, PageCacheRule.PageCacheConfig pageCacheConfig, Config config) {
        PageCacheTracer tracer = (PageCacheTracer)ConfigurablePageCacheRule.selectConfig((Object)this.baseConfig.tracer, (Object)pageCacheConfig.tracer, (Object)PageCacheTracer.NULL);
        PageCursorTracerSupplier cursorTracerSupplier = (PageCursorTracerSupplier)ConfigurablePageCacheRule.selectConfig((Object)this.baseConfig.pageCursorTracerSupplier, (Object)pageCacheConfig.pageCursorTracerSupplier, (Object)PageCursorTracerSupplier.NULL);
        config.augmentDefaults(GraphDatabaseSettings.pagecache_memory, "8M");
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.err);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fs, config, tracer, cursorTracerSupplier, logProvider.getLog(PageCache.class), EmptyVersionContextSupplier.EMPTY);
        return pageCacheFactory.getOrCreatePageCache();
    }
}

