/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.NeoStoresRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.RepeatRule;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccess;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.DataImporter;
import org.neo4j.unsafe.impl.batchimport.DeleteDuplicateNodesStep;
import org.neo4j.unsafe.impl.batchimport.staging.SimpleStageControl;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.values.storable.Values;

public class DeleteDuplicateNodesStepTest {
    private final RandomRule random = new RandomRule().withConfiguration((Randoms.Configuration)new Randoms.Default(){

        public int stringMaxLength() {
            return 200;
        }

        public int arrayMaxLength() {
            return 200;
        }
    });
    private final NeoStoresRule neoStoresRule = new NeoStoresRule(this.getClass(), new StoreType[0]);
    private final RepeatRule repeater = new RepeatRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.repeater).around((TestRule)this.random).around((TestRule)this.neoStoresRule);

    @RepeatRule.Repeat(times=10)
    @Test
    public void shouldDeleteEverythingAboutTheDuplicatedNodes() throws Exception {
        NeoStores neoStores = this.neoStoresRule.builder().build();
        Ids[] ids = new Ids[9];
        DataImporter.Monitor monitor = new DataImporter.Monitor();
        ids[0] = this.createNode(monitor, neoStores, 10, 10);
        ids[1] = this.createNode(monitor, neoStores, 10, 1);
        ids[2] = this.createNode(monitor, neoStores, 10, 0);
        ids[3] = this.createNode(monitor, neoStores, 1, 10);
        ids[4] = this.createNode(monitor, neoStores, 1, 1);
        ids[5] = this.createNode(monitor, neoStores, 1, 0);
        ids[6] = this.createNode(monitor, neoStores, 0, 10);
        ids[7] = this.createNode(monitor, neoStores, 0, 1);
        ids[8] = this.createNode(monitor, neoStores, 0, 0);
        long[] duplicateNodeIds = this.randomNodes(ids);
        SimpleStageControl control = new SimpleStageControl();
        try (DeleteDuplicateNodesStep step = new DeleteDuplicateNodesStep((StageControl)control, Configuration.DEFAULT, PrimitiveLongCollections.iterator((long[])duplicateNodeIds), neoStores.getNodeStore(), neoStores.getPropertyStore(), monitor);){
            control.steps(new Step[]{step});
            DeleteDuplicateNodesStepTest.startAndAwaitCompletionOf(step);
        }
        control.assertHealthy();
        int expectedNodes = 0;
        int expectedProperties = 0;
        for (Ids entity : ids) {
            boolean expectedToBeInUse = !ArrayUtils.contains((long[])duplicateNodeIds, (long)entity.node.getId());
            int stride = expectedToBeInUse ? 1 : 0;
            expectedNodes += stride;
            Assert.assertEquals((Object)expectedToBeInUse, (Object)neoStores.getNodeStore().isInUse(entity.node.getId()));
            for (DynamicRecord labelRecord : entity.node.getDynamicLabelRecords()) {
                Assert.assertEquals((Object)expectedToBeInUse, (Object)neoStores.getNodeStore().getDynamicLabelStore().isInUse(labelRecord.getId()));
            }
            for (PropertyRecord propertyRecord : entity.properties) {
                Assert.assertEquals((Object)expectedToBeInUse, (Object)neoStores.getPropertyStore().isInUse(propertyRecord.getId()));
                for (PropertyBlock property : propertyRecord) {
                    for (DynamicRecord valueRecord : property.getValueRecords()) {
                        DynamicStringStore valueStore;
                        switch (property.getType()) {
                            case STRING: {
                                valueStore = neoStores.getPropertyStore().getStringStore();
                                break;
                            }
                            case ARRAY: {
                                valueStore = neoStores.getPropertyStore().getArrayStore();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(propertyRecord + " " + property);
                            }
                        }
                        Assert.assertEquals((Object)expectedToBeInUse, (Object)valueStore.isInUse(valueRecord.getId()));
                    }
                    expectedProperties += stride;
                }
            }
        }
        Assert.assertEquals((long)expectedNodes, (long)monitor.nodesImported());
        Assert.assertEquals((long)expectedProperties, (long)monitor.propertiesImported());
    }

    private long[] randomNodes(Ids[] ids) {
        long[] nodeIds = new long[ids.length];
        int cursor = 0;
        for (Ids id : ids) {
            if (!this.random.nextBoolean()) continue;
            nodeIds[cursor++] = id.node.getId();
        }
        if (cursor == 0) {
            nodeIds[cursor++] = ((Ids)this.random.among((Object[])ids)).node.getId();
        }
        return Arrays.copyOf(nodeIds, cursor);
    }

    private Ids createNode(DataImporter.Monitor monitor, NeoStores neoStores, int propertyCount, int labelCount) {
        PropertyStore propertyStore = neoStores.getPropertyStore();
        DirectRecordAccess propertyRecordAccess = new DirectRecordAccess((RecordStore)propertyStore, new Loaders(neoStores).propertyLoader());
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord nodeRecord = (NodeRecord)nodeStore.newRecord();
        nodeRecord.setId(nodeStore.nextId());
        nodeRecord.setInUse(true);
        NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord).put(DeleteDuplicateNodesStepTest.labelIds(labelCount), nodeStore, (DynamicRecordAllocator)nodeStore.getDynamicLabelStore());
        long nextProp = new PropertyCreator(propertyStore, new PropertyTraverser()).createPropertyChain((PrimitiveRecord)nodeRecord, this.properties(propertyStore, propertyCount), (RecordAccess)propertyRecordAccess);
        nodeRecord.setNextProp(nextProp);
        nodeStore.updateRecord(nodeRecord);
        PropertyRecord[] propertyRecords = DeleteDuplicateNodesStepTest.extractPropertyRecords((RecordAccess<PropertyRecord, PrimitiveRecord>)propertyRecordAccess, nextProp);
        propertyRecordAccess.close();
        monitor.nodesImported(1L);
        monitor.propertiesImported((long)propertyCount);
        return new Ids(nodeRecord, propertyRecords);
    }

    private static PropertyRecord[] extractPropertyRecords(RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecordAccess, long nextProp) {
        ArrayList<PropertyRecord> result = new ArrayList<PropertyRecord>();
        while (!Record.NULL_REFERENCE.is(nextProp)) {
            PropertyRecord record = (PropertyRecord)propertyRecordAccess.getIfLoaded(nextProp).forReadingLinkage();
            result.add(record);
            nextProp = record.getNextProp();
        }
        return result.toArray(new PropertyRecord[result.size()]);
    }

    private Iterator<PropertyBlock> properties(final PropertyStore propertyStore, final int propertyCount) {
        return new PrefetchingIterator<PropertyBlock>(){
            private int i;

            protected PropertyBlock fetchNextOrNull() {
                if (this.i >= propertyCount) {
                    return null;
                }
                PropertyBlock block = new PropertyBlock();
                propertyStore.encodeValue(block, this.i, Values.of((Object)DeleteDuplicateNodesStepTest.this.random.propertyValue()));
                ++this.i;
                return block;
            }
        };
    }

    private static long[] labelIds(int labelCount) {
        long[] result = new long[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            result[i] = i;
        }
        return result;
    }

    private static void startAndAwaitCompletionOf(DeleteDuplicateNodesStep step) throws InterruptedException {
        step.start(0);
        step.receive(0L, null);
        while (!step.isCompleted()) {
            Thread.sleep(10L);
        }
    }

    private static class Ids {
        private final NodeRecord node;
        private final PropertyRecord[] properties;

        Ids(NodeRecord node, PropertyRecord[] properties) {
            this.node = node;
            this.properties = properties;
        }
    }
}

