/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.BooleanSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.test.Race;
import org.neo4j.test.rule.RepeatRule;
import org.neo4j.unsafe.impl.batchimport.HighestId;

public class HighestIdTest {
    @Rule
    public final RepeatRule repeater = new RepeatRule();

    @RepeatRule.Repeat(times=100)
    @Test
    public void shouldKeepHighest() throws Throwable {
        Race race = new Race();
        final HighestId highestId = new HighestId();
        int threads = Runtime.getRuntime().availableProcessors();
        final CountDownLatch latch = new CountDownLatch(threads);
        final AtomicLongArray highestIds = new AtomicLongArray(threads);
        int c = 0;
        while (c < threads) {
            final int cc = c++;
            race.addContestant(new Runnable(){
                boolean run;
                ThreadLocalRandom random = ThreadLocalRandom.current();

                @Override
                public void run() {
                    if (this.run) {
                        return;
                    }
                    long highest = 0L;
                    for (int i = 0; i < 10; ++i) {
                        long nextLong = this.random.nextLong(100L);
                        highestId.offer(nextLong);
                        highest = Math.max(highest, nextLong);
                    }
                    highestIds.set(cc, highest);
                    latch.countDown();
                    this.run = true;
                }
            });
        }
        race.withEndCondition(new BooleanSupplier[]{() -> latch.getCount() == 0L});
        race.go();
        long highest = 0L;
        for (int i = 0; i < threads; ++i) {
            highest = Math.max(highest, highestIds.get(i));
        }
        Assert.assertEquals((long)highest, (long)highestId.get());
    }
}

