/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayPageCacheTestSupport;

@RunWith(value=Parameterized.class)
public class NumberArrayTest
extends NumberArrayPageCacheTestSupport {
    private static NumberArrayPageCacheTestSupport.Fixture fixture;
    private static final int INDEXES = 50000;
    private static final int CHUNK_SIZE;
    @Rule
    public RandomRule random = new RandomRule();
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public NumberArray<?> array;
    @Parameterized.Parameter(value=2)
    public Function<RandomRule, Object> valueGenerator;
    @Parameterized.Parameter(value=3)
    public Writer writer;
    @Parameterized.Parameter(value=4)
    public Reader reader;

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> arrays() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] defaultByteArray(int length) {
        byte[] result = new byte[length];
        Arrays.fill(result, (byte)-1);
        return result;
    }

    private static <N extends NumberArray<N>> Object[] line(String name, N array, Function<RandomRule, Object> valueGenerator, Writer<N> writer, Reader<N> reader) {
        return new Object[]{name, array, valueGenerator, writer, reader};
    }

    @AfterClass
    public static void closeFixture() throws Exception {
        fixture.close();
    }

    @Test
    public void shouldGetAndSetRandomItems() {
        int i;
        HashMap<Integer, Object> key = new HashMap<Integer, Object>();
        Object defaultValue = this.reader.read(this.array, 0);
        for (i = 0; i < 100000; ++i) {
            int index = this.random.nextInt(50000);
            Object value = this.valueGenerator.apply(this.random);
            this.writer.write(i % 2 == 0 ? this.array : this.array.at((long)index), index, value);
            key.put(index, value);
        }
        this.assertAllValues(key, defaultValue);
        for (i = 0; i < 25000; ++i) {
            int toIndex;
            int fromIndex = this.random.nextInt(50000);
            while ((toIndex = this.random.nextInt(50000)) == fromIndex) {
            }
            Object fromValue = this.reader.read(this.array, fromIndex);
            Object toValue = this.reader.read(this.array, toIndex);
            key.put(fromIndex, toValue);
            key.put(toIndex, fromValue);
            this.array.swap((long)fromIndex, (long)toIndex);
        }
        this.assertAllValues(key, defaultValue);
    }

    private void assertAllValues(Map<Integer, Object> key, Object defaultValue) {
        for (int index = 0; index < 50000; ++index) {
            Object value = this.reader.read(index % 2 == 0 ? this.array : this.array.at((long)index), index);
            Object expectedValue = key.getOrDefault(index, defaultValue);
            if (value instanceof long[]) {
                Assert.assertArrayEquals((String)("index " + index), (long[])((long[])expectedValue), (long[])((long[])value));
                continue;
            }
            Assert.assertEquals((String)("index " + index), (Object)expectedValue, (Object)value);
        }
    }

    @After
    public void after() {
        this.array.close();
    }

    private static /* synthetic */ Object lambda$arrays$16(ByteArray array, int index) {
        return new long[]{array.getLong((long)index, 0), array.getInt((long)index, 8), array.getShort((long)index, 12), array.getByte((long)index, 14)};
    }

    private static /* synthetic */ void lambda$arrays$15(ByteArray array, int index, Object value) {
        long[] values = (long[])value;
        array.setLong((long)index, 0, values[0]);
        array.setInt((long)index, 8, (int)values[1]);
        array.setShort((long)index, 12, (short)values[2]);
        array.setByte((long)index, 14, (byte)values[3]);
    }

    static {
        CHUNK_SIZE = Integer.max(1, 500);
    }

    @FunctionalInterface
    static interface Reader<N extends NumberArray<N>> {
        public Object read(N var1, int var2);
    }

    @FunctionalInterface
    static interface Writer<N extends NumberArray<N>> {
        public void write(N var1, int var2, Object var3);
    }
}

