/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

abstract class NativeIndexProgressor<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
implements IndexProgressor {
    final RawCursor<Hit<KEY, VALUE>, IOException> seeker;
    final IndexProgressor.NodeValueClient client;
    private final Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose;
    private boolean closed;

    NativeIndexProgressor(RawCursor<Hit<KEY, VALUE>, IOException> seeker, IndexProgressor.NodeValueClient client, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose) {
        this.seeker = seeker;
        this.client = client;
        this.toRemoveFromOnClose = toRemoveFromOnClose;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.seeker.close();
                this.toRemoveFromOnClose.remove(this.seeker);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    Value[] extractValues(KEY key) {
        Value[] valueArray;
        if (this.client.needsValues()) {
            Value[] valueArray2 = new Value[1];
            valueArray = valueArray2;
            valueArray2[0] = ((NativeSchemaKey)((Object)key)).asValue();
        } else {
            valueArray = null;
        }
        return valueArray;
    }
}

