/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.CastingIterator;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.store.DefaultIndexReference;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.IndexReaders;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.NodeSchemaMatcher;
import org.neo4j.kernel.impl.newapi.TwoPhaseNodeForRelationshipLocking;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Operations
implements Write,
ExplicitIndexWrite,
SchemaWrite {
    private final KernelTransactionImplementation ktx;
    private final AllStoreHolder allStoreHolder;
    private final KernelToken token;
    private final StorageStatement statement;
    private final AutoIndexing autoIndexing;
    private DefaultNodeCursor nodeCursor;
    private final IndexTxStateUpdater updater;
    private DefaultPropertyCursor propertyCursor;
    private DefaultRelationshipScanCursor relationshipCursor;
    private final DefaultCursors cursors;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final ConstraintSemantics constraintSemantics;
    private final IndexProviderMap indexProviderMap;

    public Operations(AllStoreHolder allStoreHolder, IndexTxStateUpdater updater, StorageStatement statement, KernelTransactionImplementation ktx, KernelToken token, DefaultCursors cursors, AutoIndexing autoIndexing, ConstraintIndexCreator constraintIndexCreator, ConstraintSemantics constraintSemantics, IndexProviderMap indexProviderMap) {
        this.token = token;
        this.autoIndexing = autoIndexing;
        this.allStoreHolder = allStoreHolder;
        this.ktx = ktx;
        this.statement = statement;
        this.updater = updater;
        this.cursors = cursors;
        this.constraintIndexCreator = constraintIndexCreator;
        this.constraintSemantics = constraintSemantics;
        this.indexProviderMap = indexProviderMap;
    }

    public void initialize() {
        this.nodeCursor = this.cursors.allocateNodeCursor();
        this.propertyCursor = this.cursors.allocatePropertyCursor();
        this.relationshipCursor = this.cursors.allocateRelationshipScanCursor();
    }

    public long nodeCreate() {
        this.ktx.assertOpen();
        long nodeId = this.statement.reserveNode();
        this.ktx.txState().nodeDoCreate(nodeId);
        return nodeId;
    }

    public boolean nodeDelete(long node) throws AutoIndexingKernelException {
        this.ktx.assertOpen();
        return this.nodeDelete(node, true);
    }

    public int nodeDetachDelete(long nodeId) throws KernelException {
        MutableInt count = new MutableInt();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking((ThrowingConsumer<Long, KernelException>)((ThrowingConsumer)relId -> {
            this.ktx.assertOpen();
            if (this.relationshipDelete((long)relId, false)) {
                count.increment();
            }
        }), this.ktx.statementLocks().optimistic(), this.ktx.lockTracer());
        locking.lockAllNodesAndConsumeRelationships(nodeId, this.ktx, this.ktx.ambientNodeCursor());
        this.ktx.assertOpen();
        this.nodeDelete(nodeId, false);
        return count.intValue();
    }

    public long relationshipCreate(long sourceNode, int relationshipType, long targetNode) throws EntityNotFoundException {
        this.ktx.assertOpen();
        this.sharedRelationshipTypeLock(relationshipType);
        this.lockRelationshipNodes(sourceNode, targetNode);
        this.assertNodeExists(sourceNode);
        this.assertNodeExists(targetNode);
        long id = this.statement.reserveRelationship();
        this.ktx.txState().relationshipDoCreate(id, relationshipType, sourceNode, targetNode);
        return id;
    }

    public boolean relationshipDelete(long relationship) throws AutoIndexingKernelException {
        this.ktx.assertOpen();
        return this.relationshipDelete(relationship, true);
    }

    public boolean nodeAddLabel(long node, int nodeLabel) throws EntityNotFoundException, ConstraintValidationException {
        this.acquireSharedLabelLock(nodeLabel);
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (this.nodeCursor.labels().contains(nodeLabel)) {
            return false;
        }
        Iterator<ConstraintDescriptor> constraints = this.allStoreHolder.constraintsGetForLabel(nodeLabel);
        while (constraints.hasNext()) {
            IndexBackedConstraintDescriptor uniqueConstraint;
            IndexQuery.ExactPredicate[] propertyValues;
            ConstraintDescriptor constraint = constraints.next();
            if (!constraint.enforcesUniqueness() || (propertyValues = this.getAllPropertyValues((SchemaDescriptor)(uniqueConstraint = (IndexBackedConstraintDescriptor)constraint).schema(), -1, Values.NO_VALUE)) == null) continue;
            this.validateNoExistingNodeWithExactValues(uniqueConstraint, propertyValues, node);
        }
        this.ktx.txState().nodeDoAddLabel(nodeLabel, node);
        this.updater.onLabelChange(nodeLabel, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        return true;
    }

    private boolean nodeDelete(long node, boolean lock) throws AutoIndexingKernelException {
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            if (this.ktx.txState().nodeIsAddedInThisTx(node)) {
                this.autoIndexing.nodes().entityRemoved(this, node);
                this.ktx.txState().nodeDoDelete(node);
                return true;
            }
            if (this.ktx.txState().nodeIsDeletedInThisTx(node)) {
                return false;
            }
        }
        if (lock) {
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        }
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (this.nodeCursor.next()) {
            this.acquireSharedNodeLabelLocks();
            this.autoIndexing.nodes().entityRemoved(this, node);
            this.ktx.txState().nodeDoDelete(node);
            return true;
        }
        return false;
    }

    private void acquireSharedNodeLabelLocks() {
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.LABEL, this.nodeCursor.labels().all());
    }

    private boolean relationshipDelete(long relationship, boolean lock) throws AutoIndexingKernelException {
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (this.relationshipCursor.next()) {
            if (lock) {
                this.lockRelationshipNodes(this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
                this.acquireExclusiveRelationshipLock(relationship);
            }
            if (!this.allStoreHolder.relationshipExists(relationship)) {
                return false;
            }
            this.ktx.assertOpen();
            this.autoIndexing.relationships().entityRemoved(this, relationship);
            TransactionState txState = this.ktx.txState();
            if (txState.relationshipIsAddedInThisTx(relationship)) {
                txState.relationshipDoDeleteAddedInThisTx(relationship);
            } else {
                txState.relationshipDoDelete(relationship, this.relationshipCursor.getType(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
            }
            return true;
        }
        return false;
    }

    private void singleNode(long node) throws EntityNotFoundException {
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
    }

    private void singleRelationship(long relationship) throws EntityNotFoundException {
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationship);
        }
    }

    private IndexQuery.ExactPredicate[] getAllPropertyValues(SchemaDescriptor schema, int changedPropertyKeyId, Value changedValue) {
        int k;
        int[] schemaPropertyIds = schema.getPropertyIds();
        IndexQuery.ExactPredicate[] values = new IndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        this.nodeCursor.properties(this.propertyCursor);
        while (this.propertyCursor.next()) {
            int nodePropertyId = this.propertyCursor.propertyKey();
            int k2 = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)nodePropertyId);
            if (k2 < 0) continue;
            if (nodePropertyId != -1) {
                values[k2] = IndexQuery.exact((int)nodePropertyId, (Object)this.propertyCursor.propertyValue());
            }
            ++nMatched;
        }
        if (changedPropertyKeyId != -1 && (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropertyKeyId)) >= 0) {
            values[k] = IndexQuery.exact((int)changedPropertyKeyId, (Object)changedValue);
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private void validateNoExistingNodeWithExactValues(IndexBackedConstraintDescriptor constraint, IndexQuery.ExactPredicate[] propertyValues, long modifiedNode) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        SchemaIndexDescriptor schemaIndexDescriptor = constraint.ownedIndexDescriptor();
        CapableIndexReference indexReference = this.allStoreHolder.indexGetCapability(schemaIndexDescriptor);
        try (DefaultNodeValueIndexCursor valueCursor = this.cursors.allocateNodeValueIndexCursor();
             IndexReaders indexReaders = new IndexReaders((IndexReference)indexReference, this.allStoreHolder);){
            this.assertIndexOnline(schemaIndexDescriptor);
            int labelId = schemaIndexDescriptor.schema().keyId();
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.INDEX_ENTRY, ResourceTypes.indexEntryResourceId(labelId, propertyValues));
            this.allStoreHolder.nodeIndexSeekWithFreshIndexReader(valueCursor, indexReaders.createReader(), propertyValues);
            if (valueCursor.next() && valueCursor.nodeReference() != modifiedNode) {
                throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(valueCursor.nodeReference(), -1L, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])propertyValues)));
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException(constraint, (Throwable)e);
        }
    }

    private void assertIndexOnline(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        switch (this.allStoreHolder.indexGetState(descriptor)) {
            case ONLINE: {
                return;
            }
        }
        throw new IndexBrokenKernelException(this.allStoreHolder.indexGetFailure(descriptor));
    }

    public boolean nodeRemoveLabel(long node, int labelId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (!this.nodeCursor.labels().contains(labelId)) {
            return false;
        }
        this.acquireSharedLabelLock(labelId);
        this.ktx.txState().nodeDoRemoveLabel(labelId, node);
        this.updater.onLabelChange(labelId, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        return true;
    }

    public Value nodeSetProperty(long node, int propertyKey, Value value) throws EntityNotFoundException, ConstraintValidationException, AutoIndexingKernelException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        this.acquireSharedNodeLabelLocks();
        Iterator<ConstraintDescriptor> constraints = this.allStoreHolder.constraintsGetForProperty(propertyKey);
        CastingIterator uniquenessConstraints = new CastingIterator(constraints, IndexBackedConstraintDescriptor.class);
        NodeSchemaMatcher.onMatchingSchema(uniquenessConstraints, this.nodeCursor, this.propertyCursor, propertyKey, (constraint, propertyIds) -> {
            Value previousValue;
            if (propertyIds.contains(propertyKey) && value.equals(previousValue = this.readNodeProperty(propertyKey))) {
                return;
            }
            this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)constraint, this.getAllPropertyValues((SchemaDescriptor)constraint.schema(), propertyKey, value), node);
        });
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue == Values.NO_VALUE) {
            this.autoIndexing.nodes().propertyAdded(this, node, propertyKey, value);
            this.ktx.txState().nodeDoAddProperty(node, propertyKey, value);
            this.updater.onPropertyAdd(this.nodeCursor, this.propertyCursor, propertyKey, value);
            return Values.NO_VALUE;
        }
        if (this.propertyHasChanged(value, existingValue)) {
            this.autoIndexing.nodes().propertyChanged(this, node, propertyKey, existingValue, value);
            this.ktx.txState().nodeDoChangeProperty(node, propertyKey, existingValue, value);
            this.updater.onPropertyChange(this.nodeCursor, this.propertyCursor, propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value nodeRemoveProperty(long node, int propertyKey) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.acquireSharedNodeLabelLocks();
            this.autoIndexing.nodes().propertyRemoved(this, node, propertyKey);
            this.ktx.txState().nodeDoRemoveProperty(node, propertyKey);
            this.updater.onPropertyRemove(this.nodeCursor, this.propertyCursor, propertyKey, existingValue);
        }
        return existingValue;
    }

    public Value relationshipSetProperty(long relationship, int propertyKey, Value value) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue == Values.NO_VALUE) {
            this.autoIndexing.relationships().propertyAdded(this, relationship, propertyKey, value);
            this.ktx.txState().relationshipDoReplaceProperty(relationship, propertyKey, Values.NO_VALUE, value);
            return Values.NO_VALUE;
        }
        if (this.propertyHasChanged(existingValue, value)) {
            this.autoIndexing.relationships().propertyChanged(this, relationship, propertyKey, existingValue, value);
            this.ktx.txState().relationshipDoReplaceProperty(relationship, propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value relationshipRemoveProperty(long relationship, int propertyKey) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.autoIndexing.relationships().propertyRemoved(this, relationship, propertyKey);
            this.ktx.txState().relationshipDoRemoveProperty(relationship, propertyKey);
        }
        return existingValue;
    }

    public Value graphSetProperty(int propertyKey, Value value) {
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        this.ktx.assertOpen();
        Value existingValue = this.readGraphProperty(propertyKey);
        if (!existingValue.equals(value)) {
            this.ktx.txState().graphDoReplaceProperty(propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value graphRemoveProperty(int propertyKey) {
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        this.ktx.assertOpen();
        Value existingValue = this.readGraphProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.ktx.txState().graphDoRemoveProperty(propertyKey);
        }
        return existingValue;
    }

    public void nodeAddToExplicitIndex(String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().nodeChanges(indexName).addNode(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().nodeChanges(indexName).remove(node);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().nodeChanges(indexName).remove(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().nodeChanges(indexName).remove(node, key);
    }

    public void nodeExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().createIndex(IndexEntityType.Node, indexName, customConfig);
    }

    public void nodeExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    public void nodeExplicitIndexDrop(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ExplicitIndexTransactionState txState = this.allStoreHolder.explicitIndexTxState();
        txState.nodeChanges(indexName).drop();
        txState.deleteIndex(IndexEntityType.Node, indexName);
    }

    public String nodeExplicitIndexSetConfiguration(String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.allStoreHolder.explicitIndexStore().setNodeIndexConfiguration(indexName, key, value);
    }

    public String nodeExplicitIndexRemoveConfiguration(String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.allStoreHolder.explicitIndexStore().removeNodeIndexConfiguration(indexName, key);
    }

    public void relationshipAddToExplicitIndex(String indexName, long relationship, String key, Object value) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.ktx.assertOpen();
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationship);
        }
        this.allStoreHolder.explicitIndexTxState().relationshipChanges(indexName).addRelationship(relationship, key, value, this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference());
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key, value);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().relationshipChanges(indexName).remove(relationship);
    }

    public void relationshipExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.explicitIndexTxState().createIndex(IndexEntityType.Relationship, indexName, customConfig);
    }

    public void relationshipExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    public void relationshipExplicitIndexDrop(String indexName) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        ExplicitIndexTransactionState txState = this.allStoreHolder.explicitIndexTxState();
        txState.relationshipChanges(indexName).drop();
        txState.deleteIndex(IndexEntityType.Relationship, indexName);
    }

    private Value readNodeProperty(int propertyKey) {
        this.nodeCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    private Value readRelationshipProperty(int propertyKey) {
        this.relationshipCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    private Value readGraphProperty(int propertyKey) {
        this.allStoreHolder.graphProperties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public Procedures procedures() {
        return this.allStoreHolder;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
        if (this.relationshipCursor != null) {
            this.relationshipCursor.close();
            this.relationshipCursor = null;
        }
        this.cursors.assertClosed();
        this.cursors.release();
    }

    public Token token() {
        return this.token;
    }

    public ExplicitIndexRead indexRead() {
        return this.allStoreHolder;
    }

    public SchemaRead schemaRead() {
        return this.allStoreHolder;
    }

    public Read dataRead() {
        return this.allStoreHolder;
    }

    public DefaultNodeCursor nodeCursor() {
        return this.nodeCursor;
    }

    public DefaultRelationshipScanCursor relationshipCursor() {
        return this.relationshipCursor;
    }

    public DefaultPropertyCursor propertyCursor() {
        return this.propertyCursor;
    }

    public IndexReference indexCreate(SchemaDescriptor descriptor, String providerName) throws SchemaKernelException {
        this.acquireExclusiveLabelLock(descriptor.keyId());
        this.ktx.assertOpen();
        this.assertValidDescriptor(descriptor, SchemaKernelException.OperationContext.INDEX_CREATION);
        this.assertIndexDoesNotExist(SchemaKernelException.OperationContext.INDEX_CREATION, descriptor);
        SchemaIndexDescriptor indexDescriptor = SchemaIndexDescriptorFactory.forSchema(descriptor);
        IndexProvider.Descriptor providerDescriptor = this.providerByName(providerName);
        this.ktx.txState().indexRuleDoAdd(indexDescriptor, providerDescriptor);
        return DefaultIndexReference.fromDescriptor(indexDescriptor);
    }

    public void indexDrop(IndexReference index) throws SchemaKernelException {
        this.assertValidIndex(index);
        this.acquireExclusiveLabelLock(index.label());
        this.ktx.assertOpen();
        LabelSchemaDescriptor descriptor = this.labelDescriptor(index);
        try {
            SchemaIndexDescriptor existingIndex = this.allStoreHolder.indexGetForSchema((SchemaDescriptor)descriptor);
            if (existingIndex == null) {
                throw new NoSuchIndexException((SchemaDescriptor)descriptor);
            }
            if (existingIndex.type() == SchemaIndexDescriptor.Type.UNIQUE && this.allStoreHolder.indexGetOwningUniquenessConstraintId(existingIndex) != null) {
                throw new IndexBelongsToConstraintException((SchemaDescriptor)descriptor);
            }
        }
        catch (IndexBelongsToConstraintException | NoSuchIndexException e) {
            throw new DropIndexFailureException((SchemaDescriptor)descriptor, e);
        }
        this.ktx.txState().indexDoDrop(this.allStoreHolder.indexDescriptor(index));
    }

    public ConstraintDescriptor uniquePropertyConstraintCreate(SchemaDescriptor descriptor, String providerName) throws SchemaKernelException {
        this.acquireExclusiveLabelLock(descriptor.keyId());
        this.ktx.assertOpen();
        this.assertValidDescriptor(descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema(descriptor);
        this.assertConstraintDoesNotExist(constraint);
        this.assertIndexDoesNotExist(SchemaKernelException.OperationContext.CONSTRAINT_CREATION, descriptor);
        IndexProvider.Descriptor providerDescriptor = this.providerByName(providerName);
        this.indexBackedConstraintCreate(constraint, providerDescriptor);
        return constraint;
    }

    public ConstraintDescriptor nodeKeyConstraintCreate(org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor descriptor, String providerName) throws SchemaKernelException {
        this.acquireExclusiveLabelLock(descriptor.getLabelId());
        this.ktx.assertOpen();
        this.assertValidDescriptor((SchemaDescriptor)descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        NodeKeyConstraintDescriptor constraint = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)descriptor);
        this.assertConstraintDoesNotExist(constraint);
        this.assertIndexDoesNotExist(SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (SchemaDescriptor)descriptor);
        try (DefaultNodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor();){
            this.allStoreHolder.nodeLabelScan(descriptor.getLabelId(), nodes);
            this.constraintSemantics.validateNodeKeyConstraint(nodes, this.nodeCursor, this.propertyCursor, descriptor);
        }
        IndexProvider.Descriptor providerDescriptor = this.providerByName(providerName);
        this.indexBackedConstraintCreate(constraint, providerDescriptor);
        return constraint;
    }

    public ConstraintDescriptor nodePropertyExistenceConstraintCreate(org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor descriptor) throws SchemaKernelException {
        this.acquireExclusiveLabelLock(descriptor.getLabelId());
        this.ktx.assertOpen();
        this.assertValidDescriptor((SchemaDescriptor)descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        NodeExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema(descriptor);
        this.assertConstraintDoesNotExist(constraint);
        try (DefaultNodeLabelIndexCursor nodes = this.cursors.allocateNodeLabelIndexCursor();){
            this.allStoreHolder.nodeLabelScan(descriptor.getLabelId(), nodes);
            this.constraintSemantics.validateNodePropertyExistenceConstraint(nodes, this.nodeCursor, this.propertyCursor, descriptor);
        }
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    public ConstraintDescriptor relationshipPropertyExistenceConstraintCreate(RelationTypeSchemaDescriptor descriptor) throws SchemaKernelException {
        this.exclusiveRelationshipTypeLock(descriptor.getRelTypeId());
        this.ktx.assertOpen();
        this.assertValidDescriptor((SchemaDescriptor)descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema(descriptor);
        this.assertConstraintDoesNotExist(constraint);
        this.allStoreHolder.relationshipTypeScan(descriptor.getRelTypeId(), this.relationshipCursor);
        this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(this.relationshipCursor, this.propertyCursor, descriptor);
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    public String relationshipExplicitIndexSetConfiguration(String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.allStoreHolder.explicitIndexStore().setRelationshipIndexConfiguration(indexName, key, value);
    }

    public String relationshipExplicitIndexRemoveConfiguration(String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        return this.allStoreHolder.explicitIndexStore().removeRelationshipIndexConfiguration(indexName, key);
    }

    public void constraintDrop(ConstraintDescriptor descriptor) throws SchemaKernelException {
        SchemaDescriptor schema = descriptor.schema();
        this.exclusiveOptimisticLock(schema.keyType(), schema.keyId());
        this.ktx.assertOpen();
        try {
            this.assertConstraintExists(descriptor);
        }
        catch (NoSuchConstraintException e) {
            throw new DropConstraintFailureException(descriptor, (Throwable)((Object)e));
        }
        this.ktx.txState().constraintDoDrop(descriptor);
    }

    private void assertIndexDoesNotExist(SchemaKernelException.OperationContext context, SchemaDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException {
        SchemaIndexDescriptor existingIndex = this.allStoreHolder.indexGetForSchema(descriptor);
        if (existingIndex != null) {
            if (existingIndex.type() == SchemaIndexDescriptor.Type.UNIQUE) {
                if (context != SchemaKernelException.OperationContext.CONSTRAINT_CREATION || this.constraintIndexHasOwner(existingIndex)) {
                    throw new AlreadyConstrainedException(ConstraintDescriptorFactory.uniqueForSchema(descriptor), context, new SilentTokenNameLookup((TokenRead)this.token));
                }
            } else {
                throw new AlreadyIndexedException(descriptor, context);
            }
        }
    }

    private void exclusiveOptimisticLock(ResourceType resource, long resourceId) {
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), resource, resourceId);
    }

    private void acquireExclusiveNodeLock(long node) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().nodeIsAddedInThisTx(node)) {
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        }
    }

    private void acquireExclusiveRelationshipLock(long relationshipId) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().relationshipIsAddedInThisTx(relationshipId)) {
            this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.RELATIONSHIP, relationshipId);
        }
    }

    private void acquireSharedLabelLock(int labelId) {
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.LABEL, labelId);
    }

    private void acquireExclusiveLabelLock(int labelId) {
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.LABEL, labelId);
    }

    private void sharedRelationshipTypeLock(long typeId) {
        this.ktx.statementLocks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.RELATIONSHIP_TYPE, typeId);
    }

    private void exclusiveRelationshipTypeLock(long typeId) {
        this.ktx.statementLocks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.RELATIONSHIP_TYPE, typeId);
    }

    private void lockRelationshipNodes(long startNodeId, long endNodeId) {
        this.acquireExclusiveNodeLock(Math.min(startNodeId, endNodeId));
        if (startNodeId != endNodeId) {
            this.acquireExclusiveNodeLock(Math.max(startNodeId, endNodeId));
        }
    }

    private boolean propertyHasChanged(Value lhs, Value rhs) {
        return lhs.getClass() != rhs.getClass() || !lhs.equals(rhs);
    }

    private void assertNodeExists(long sourceNode) throws EntityNotFoundException {
        if (!this.allStoreHolder.nodeExists(sourceNode)) {
            throw new EntityNotFoundException(EntityType.NODE, sourceNode);
        }
    }

    private boolean constraintIndexHasOwner(SchemaIndexDescriptor descriptor) {
        return this.allStoreHolder.indexGetOwningUniquenessConstraintId(descriptor) != null;
    }

    private void assertConstraintDoesNotExist(ConstraintDescriptor constraint) throws AlreadyConstrainedException {
        if (this.allStoreHolder.constraintExists(constraint)) {
            throw new AlreadyConstrainedException(constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new SilentTokenNameLookup((TokenRead)this.token));
        }
    }

    public Locks locks() {
        return this.allStoreHolder;
    }

    private void assertConstraintExists(ConstraintDescriptor constraint) throws NoSuchConstraintException {
        if (!this.allStoreHolder.constraintExists(constraint)) {
            throw new NoSuchConstraintException(constraint);
        }
    }

    private void assertValidDescriptor(SchemaDescriptor descriptor, SchemaKernelException.OperationContext context) throws RepeatedPropertyInCompositeSchemaException {
        int numUnique = Arrays.stream(descriptor.getPropertyIds()).distinct().toArray().length;
        if (numUnique != descriptor.getPropertyIds().length) {
            throw new RepeatedPropertyInCompositeSchemaException(descriptor, context);
        }
    }

    private LabelSchemaDescriptor labelDescriptor(IndexReference index) {
        return SchemaDescriptorFactory.forLabel(index.label(), index.properties());
    }

    private void indexBackedConstraintCreate(IndexBackedConstraintDescriptor constraint, IndexProvider.Descriptor providerDescriptor) throws CreateConstraintFailureException {
        org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor descriptor = constraint.schema();
        try {
            if (this.ktx.hasTxStateWithChanges() && this.ktx.txState().indexDoUnRemove(constraint.ownedIndexDescriptor())) {
                if (!this.ktx.txState().constraintDoUnRemove(constraint)) {
                    this.ktx.txState().constraintDoAdd(constraint, this.ktx.txState().indexCreatedForConstraint(constraint));
                }
            } else {
                Iterator<ConstraintDescriptor> it = this.allStoreHolder.constraintsGetForSchema((SchemaDescriptor)descriptor);
                while (it.hasNext()) {
                    if (!it.next().equals(constraint)) continue;
                    return;
                }
                long indexId = this.constraintIndexCreator.createUniquenessConstraintIndex(this.ktx, (SchemaDescriptor)descriptor, providerDescriptor);
                if (!this.allStoreHolder.constraintExists(constraint)) {
                    this.ktx.txState().constraintDoAdd(constraint, indexId);
                }
            }
        }
        catch (TransactionFailureException | AlreadyConstrainedException | UniquePropertyValueValidationException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, (Throwable)e);
        }
    }

    private void assertValidIndex(IndexReference index) throws NoSuchIndexException {
        if (index == CapableIndexReference.NO_INDEX) {
            throw new NoSuchIndexException((SchemaDescriptor)SchemaDescriptorFactory.forLabel(index.label(), index.properties()));
        }
    }

    private IndexProvider.Descriptor providerByName(String providerName) {
        return providerName != null ? this.indexProviderMap.lookup(providerName).getProviderDescriptor() : null;
    }
}

