/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class TransactionLogsInSeparateLocationIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final FileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void databaseWithTransactionLogsInSeparateRelativeLocation() throws IOException {
        File storeDir = this.testDirectory.graphDbDir();
        File txDirectory = new File(storeDir, "transaction-logs");
        this.performTransactions(txDirectory.getName(), storeDir);
        this.verifyTransactionLogs(txDirectory, storeDir);
    }

    @Test
    public void databaseWithTransactionLogsInSeparateAbsoluteLocation() throws IOException {
        File storeDir = this.testDirectory.graphDbDir();
        File txDirectory = this.testDirectory.directory("transaction-logs");
        this.performTransactions(txDirectory.getAbsolutePath(), storeDir);
        this.verifyTransactionLogs(txDirectory, storeDir);
    }

    private void performTransactions(String txPath, File storeDir) {
        GraphDatabaseService database = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.logical_logs_location, txPath).newGraphDatabase();
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node = database.createNode();
                node.setProperty("a", (Object)"b");
                node.setProperty("c", (Object)"d");
                transaction.success();
                continue;
            }
        }
        database.shutdown();
    }

    private void verifyTransactionLogs(File txDirectory, File storeDir) throws IOException {
        FileSystemAbstraction fileSystem = this.fileSystemRule.get();
        LogFiles storeDirLogs = LogFilesBuilder.logFilesBasedOnlyBuilder((File)storeDir, (FileSystemAbstraction)fileSystem).build();
        Assert.assertFalse((boolean)storeDirLogs.versionExists(0L));
        LogFiles txDirectoryLogs = LogFilesBuilder.logFilesBasedOnlyBuilder((File)txDirectory, (FileSystemAbstraction)fileSystem).build();
        Assert.assertTrue((boolean)txDirectoryLogs.versionExists(0L));
        try (PhysicalLogVersionedStoreChannel physicalLogVersionedStoreChannel = txDirectoryLogs.openForVersion(0L);){
            Assert.assertThat((Object)physicalLogVersionedStoreChannel.size(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        }
    }
}

