/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.TaskControl;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.test.Barrier;

public class TaskCoordinatorTest {
    @Test
    public void shouldCancelAllTasksWithOneCall() {
        TaskCoordinator coordinator = new TaskCoordinator(1L, TimeUnit.MILLISECONDS);
        try (TaskControl task1 = coordinator.newInstance();
             TaskControl task2 = coordinator.newInstance();
             TaskControl task3 = coordinator.newInstance();){
            Assert.assertFalse((boolean)task1.cancellationRequested());
            Assert.assertFalse((boolean)task2.cancellationRequested());
            Assert.assertFalse((boolean)task3.cancellationRequested());
            coordinator.cancel();
            Assert.assertTrue((boolean)task1.cancellationRequested());
            Assert.assertTrue((boolean)task2.cancellationRequested());
            Assert.assertTrue((boolean)task3.cancellationRequested());
        }
    }

    @Test
    public void shouldAwaitCompletionOfAllTasks() throws Exception {
        final TaskCoordinator coordinator = new TaskCoordinator(1L, TimeUnit.MILLISECONDS);
        final AtomicReference<String> state = new AtomicReference<String>();
        final ArrayList states = new ArrayList();
        final Barrier.Control phaseA = new Barrier.Control();
        final Barrier.Control phaseB = new Barrier.Control();
        final Barrier.Control phaseC = new Barrier.Control();
        state.set("A");
        new Thread("awaitCompletion"){

            @Override
            public void run() {
                try {
                    states.add(state.get());
                    phaseA.reached();
                    states.add(state.get());
                    phaseB.await();
                    phaseB.release();
                    coordinator.awaitCompletion();
                    states.add(state.get());
                    phaseC.reached();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        try (TaskControl task1 = coordinator.newInstance();
             TaskControl task2 = coordinator.newInstance();){
            phaseA.await();
            state.set("B");
            phaseA.release();
            phaseC.release();
            phaseB.reached();
            state.set("C");
        }
        phaseC.await();
        Assert.assertEquals(Arrays.asList("A", "B", "C"), states);
    }
}

