/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.mockito.Mockito;
import org.neo4j.collection.pool.Pool;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.time.Clocks;

public class KernelTransactionFactory {
    private KernelTransactionFactory() {
    }

    private static Instances kernelTransactionWithInternals(LoginContext loginContext) {
        TransactionHeaderInformation headerInformation = new TransactionHeaderInformation(-1, -1, new byte[0]);
        TransactionHeaderInformationFactory headerInformationFactory = (TransactionHeaderInformationFactory)Mockito.mock(TransactionHeaderInformationFactory.class);
        Mockito.when((Object)headerInformationFactory.create()).thenReturn((Object)headerInformation);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        Mockito.when((Object)storeReadLayer.newStatement()).thenReturn((Object)storageStatement);
        Mockito.when((Object)storageEngine.storeReadLayer()).thenReturn((Object)storeReadLayer);
        KernelTransactionImplementation transaction = new KernelTransactionImplementation((StatementOperationParts)Mockito.mock(StatementOperationParts.class), (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), new TransactionHooks(), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), new Procedures(), headerInformationFactory, (TransactionCommitProcess)Mockito.mock(TransactionRepresentationCommitProcess.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), (Supplier)Mockito.mock(Supplier.class), (Pool)Mockito.mock(Pool.class), Clocks.nanoClock(), new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), new AtomicReference<HeapAllocation>(HeapAllocation.NOT_AVAILABLE), TransactionTracer.NULL, LockTracer.NONE, PageCursorTracerSupplier.NULL, storageEngine, (AccessCapability)new CanWrite(), new DefaultCursors(), AutoIndexing.UNSUPPORTED, (ExplicitIndexStore)Mockito.mock(ExplicitIndexStore.class), EmptyVersionContextSupplier.EMPTY, CollectionsFactorySupplier.ON_HEAP, (ConstraintSemantics)new StandardConstraintSemantics(), (SchemaState)Mockito.mock(SchemaState.class), (IndexingService)Mockito.mock(IndexingService.class), (IndexProviderMap)Mockito.mock(IndexProviderMap.class));
        SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)new NoOpClient());
        transaction.initialize(0L, 0L, (StatementLocks)statementLocks, Transaction.Type.implicit, loginContext.authorize(s -> -1), 0L, 1L);
        return new Instances(transaction, storageEngine, storeReadLayer, storageStatement);
    }

    static KernelTransaction kernelTransaction(LoginContext loginContext) {
        return KernelTransactionFactory.kernelTransactionWithInternals((LoginContext)loginContext).transaction;
    }

    public static class Instances {
        public KernelTransactionImplementation transaction;
        public StorageEngine storageEngine;
        public StoreReadLayer storeReadLayer;
        public StorageStatement storageStatement;

        public Instances(KernelTransactionImplementation transaction, StorageEngine storageEngine, StoreReadLayer storeReadLayer, StorageStatement storageStatement) {
            this.transaction = transaction;
            this.storageEngine = storageEngine;
            this.storeReadLayer = storeReadLayer;
            this.storageStatement = storageStatement;
        }
    }
}

