/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Collections;
import java.util.Map;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.IndividualSettingsValidator;
import org.neo4j.logging.Log;

public class IndividualSettingsValidatorTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private Log log;

    @Before
    public void setup() {
        this.log = (Log)Mockito.mock(Log.class);
    }

    @Test
    public void nonStrictRetainsSettings() {
        IndividualSettingsValidator iv = new IndividualSettingsValidator(Collections.singletonList(GraphDatabaseSettings.strict_config_validation), true);
        Map rawConfig = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.strict_config_validation.name(), "false", "dbms.jibber.jabber", "bla", "external_plugin.foo", "bar"});
        Config config = this.mockConfig(rawConfig);
        iv.validate(config, this.log);
        ((Log)Mockito.verify((Object)this.log)).warn("Unknown config option: %s", new Object[]{"dbms.jibber.jabber"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.log});
    }

    @Test
    public void strictErrorsOnUnknownSettingsInOurNamespace() {
        IndividualSettingsValidator iv = new IndividualSettingsValidator(Collections.singletonList(GraphDatabaseSettings.strict_config_validation), true);
        Map rawConfig = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.strict_config_validation.name(), "true", "dbms.jibber.jabber", "bla", "external_plugin.foo", "bar"});
        Config config = this.mockConfig(rawConfig);
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage(String.format("Unknown config option 'dbms.jibber.jabber'. To resolve either remove it from your configuration or set '%s' to false.", GraphDatabaseSettings.strict_config_validation.name()));
        iv.validate(config, this.log);
    }

    @Test
    public void strictAllowsStuffOutsideOurNamespace() {
        IndividualSettingsValidator iv = new IndividualSettingsValidator(Collections.singletonList(GraphDatabaseSettings.strict_config_validation), true);
        Map rawConfig = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.strict_config_validation.name(), "true", "external_plugin.foo", "bar"});
        Config config = this.mockConfig(rawConfig);
        iv.validate(config, this.log);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.log});
    }

    private Config mockConfig(Map<String, String> rawConfig) {
        Config config = (Config)Mockito.mock(Config.class);
        Mockito.when((Object)config.getRaw()).thenReturn(rawConfig);
        Mockito.when((Object)config.get(GraphDatabaseSettings.strict_config_validation)).thenReturn((Object)Boolean.valueOf(rawConfig.get(GraphDatabaseSettings.strict_config_validation.name())));
        return config;
    }
}

