/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionImplementationHandle;
import org.neo4j.kernel.impl.api.KernelTransactionTimeoutMonitor;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class KernelTransactionTimeoutMonitorTest {
    private static final int EXPECTED_REUSE_COUNT = 2;
    private KernelTransactions kernelTransactions;
    private FakeClock fakeClock;
    private AssertableLogProvider logProvider;
    private LogService logService;

    @Before
    public void setUp() {
        this.kernelTransactions = (KernelTransactions)Mockito.mock(KernelTransactions.class);
        this.fakeClock = Clocks.fakeClock();
        this.logProvider = new AssertableLogProvider();
        this.logService = new SimpleLogService((LogProvider)this.logProvider, (LogProvider)this.logProvider);
    }

    @Test
    public void terminateExpiredTransactions() {
        HashSet<KernelTransactionImplementationHandle> transactions = new HashSet<KernelTransactionImplementationHandle>();
        KernelTransactionImplementation tx1 = this.prepareTxMock(1L, 3L);
        KernelTransactionImplementation tx2 = this.prepareTxMock(1L, 8L);
        KernelTransactionImplementationHandle handle1 = new KernelTransactionImplementationHandle(tx1, (SystemNanoClock)this.fakeClock);
        KernelTransactionImplementationHandle handle2 = new KernelTransactionImplementationHandle(tx2, (SystemNanoClock)this.fakeClock);
        transactions.add(handle1);
        transactions.add(handle2);
        Mockito.when((Object)this.kernelTransactions.activeTransactions()).thenReturn(transactions);
        KernelTransactionTimeoutMonitor transactionMonitor = this.buildTransactionMonitor();
        this.fakeClock.forward(3L, TimeUnit.MILLISECONDS);
        transactionMonitor.run();
        ((KernelTransactionImplementation)Mockito.verify((Object)tx1, (VerificationMode)Mockito.never())).markForTermination((Status)Status.Transaction.TransactionTimedOut);
        ((KernelTransactionImplementation)Mockito.verify((Object)tx2, (VerificationMode)Mockito.never())).markForTermination((Status)Status.Transaction.TransactionTimedOut);
        this.logProvider.assertNoMessagesContaining("timeout");
        this.fakeClock.forward(2L, TimeUnit.MILLISECONDS);
        transactionMonitor.run();
        ((KernelTransactionImplementation)Mockito.verify((Object)tx1)).markForTermination(2L, (Status)Status.Transaction.TransactionTimedOut);
        ((KernelTransactionImplementation)Mockito.verify((Object)tx2, (VerificationMode)Mockito.never())).markForTermination((Status)Status.Transaction.TransactionTimedOut);
        this.logProvider.assertContainsLogCallContaining("timeout");
        this.logProvider.clear();
        this.fakeClock.forward(10L, TimeUnit.MILLISECONDS);
        transactionMonitor.run();
        ((KernelTransactionImplementation)Mockito.verify((Object)tx2)).markForTermination(2L, (Status)Status.Transaction.TransactionTimedOut);
        this.logProvider.assertContainsLogCallContaining("timeout");
    }

    @Test
    public void skipTransactionWithoutTimeout() {
        HashSet<KernelTransactionImplementationHandle> transactions = new HashSet<KernelTransactionImplementationHandle>();
        KernelTransactionImplementation tx1 = this.prepareTxMock(3L, 0L);
        KernelTransactionImplementation tx2 = this.prepareTxMock(4L, 0L);
        KernelTransactionImplementationHandle handle1 = new KernelTransactionImplementationHandle(tx1, (SystemNanoClock)this.fakeClock);
        KernelTransactionImplementationHandle handle2 = new KernelTransactionImplementationHandle(tx2, (SystemNanoClock)this.fakeClock);
        transactions.add(handle1);
        transactions.add(handle2);
        Mockito.when((Object)this.kernelTransactions.activeTransactions()).thenReturn(transactions);
        KernelTransactionTimeoutMonitor transactionMonitor = this.buildTransactionMonitor();
        this.fakeClock.forward(300L, TimeUnit.MILLISECONDS);
        transactionMonitor.run();
        ((KernelTransactionImplementation)Mockito.verify((Object)tx1, (VerificationMode)Mockito.never())).markForTermination((Status)Status.Transaction.TransactionTimedOut);
        ((KernelTransactionImplementation)Mockito.verify((Object)tx2, (VerificationMode)Mockito.never())).markForTermination((Status)Status.Transaction.TransactionTimedOut);
        this.logProvider.assertNoMessagesContaining("timeout");
    }

    private KernelTransactionTimeoutMonitor buildTransactionMonitor() {
        return new KernelTransactionTimeoutMonitor(this.kernelTransactions, (SystemNanoClock)this.fakeClock, this.logService);
    }

    private KernelTransactionImplementation prepareTxMock(long startMillis, long timeoutMillis) {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)transaction.startTime()).thenReturn((Object)startMillis);
        Mockito.when((Object)transaction.getReuseCount()).thenReturn((Object)2);
        Mockito.when((Object)transaction.timeout()).thenReturn((Object)timeoutMillis);
        Mockito.when((Object)transaction.markForTermination(2L, (Status)Status.Transaction.TransactionTimedOut)).thenReturn((Object)true);
        return transaction;
    }
}

