/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Modes;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Session;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.store.DefaultCapableIndexReference;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class ConstraintIndexCreatorTest {
    private static final int PROPERTY_KEY_ID = 456;
    private static final int LABEL_ID = 123;
    private static final long INDEX_ID = 2468L;
    private final LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{456});
    private final SchemaIndexDescriptor index = SchemaIndexDescriptorFactory.uniqueForLabel((int)123, (int[])new int[]{456});
    private final CapableIndexReference indexReference = new DefaultCapableIndexReference(true, IndexCapability.NO_CAPABILITY, new IndexProvider.Descriptor("foo", "1.872"), 123, new int[]{456});
    private final SchemaRead schemaRead = this.schemaRead();
    private final TokenRead tokenRead = (TokenRead)Mockito.mock(TokenRead.class);
    private AssertableLogProvider logProvider = new AssertableLogProvider();

    @Test
    public void shouldCreateIndexInAnotherTransaction() throws Exception {
        StubKernel kernel = new StubKernel();
        StatementOperationParts indexCreationContext = StatementOperationsTestHelper.mockedParts();
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        Mockito.when((Object)indexingService.getIndexProxy(2468L)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, (LogProvider)this.logProvider);
        long indexId = creator.createUniquenessConstraintIndex(this.createTransaction(), (SchemaDescriptor)this.descriptor, null);
        Assert.assertEquals((long)2468L, (long)indexId);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetCommittedId((IndexReference)this.indexReference);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index(123, new int[]{456});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted();
    }

    @Test
    public void shouldDropIndexIfPopulationFails() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(2468L)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        IndexEntryConflictException cause = new IndexEntryConflictException(2L, 1L, new Value[]{Values.of((Object)"a")});
        ((IndexProxy)Mockito.doThrow((Throwable[])new Throwable[]{new IndexPopulationFailedKernelException((SchemaDescriptor)this.descriptor, "some index", (Throwable)cause)}).when((Object)indexProxy)).awaitStoreScanCompleted();
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        Mockito.when((Object)this.schemaRead.index(ArgumentMatchers.anyInt(), new int[]{ArgumentMatchers.anyInt()})).thenReturn((Object)CapableIndexReference.NO_INDEX).thenReturn((Object)this.indexReference);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        try {
            creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, null);
            Assert.fail((String)"expected exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertEquals((Object)"Existing data does not satisfy CONSTRAINT ON ( label[123]:label[123] ) ASSERT label[123].property[456] IS UNIQUE: Both node 2 and node 1 share the property value ( String(\"a\") )", (Object)e.getMessage());
        }
        Assert.assertEquals((long)2L, (long)kernel.transactions.size());
        TransactionState tx1 = ((KernelTransactionImplementation)kernel.transactions.get(0)).txState();
        SchemaIndexDescriptor newIndex = SchemaIndexDescriptorFactory.uniqueForLabel((int)123, (int[])new int[]{456});
        ((TransactionState)Mockito.verify((Object)tx1)).indexRuleDoAdd(newIndex, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx1});
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetCommittedId((IndexReference)this.indexReference);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead, (VerificationMode)Mockito.times((int)2))).index(123, new int[]{456});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
        TransactionState tx2 = ((KernelTransactionImplementation)kernel.transactions.get(1)).txState();
        ((TransactionState)Mockito.verify((Object)tx2)).indexDoDrop(newIndex);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx2});
    }

    @Test
    public void shouldDropIndexInAnotherTransaction() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, (LogProvider)this.logProvider);
        creator.dropUniquenessConstraintIndex(this.index);
        Assert.assertEquals((long)1L, (long)kernel.transactions.size());
        ((TransactionState)Mockito.verify((Object)((KernelTransactionImplementation)kernel.transactions.get(0)).txState())).indexDoDrop(this.index);
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexingService});
    }

    @Test
    public void shouldReleaseLabelLockWhileAwaitingIndexPopulation() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        Mockito.when((Object)this.schemaRead.indexGetCommittedId((IndexReference)this.indexReference)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(ArgumentMatchers.anyLong())).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.schemaRead.index(123, new int[]{456})).thenReturn((Object)CapableIndexReference.NO_INDEX);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, null);
        ((Locks.Client)Mockito.verify((Object)transaction.statementLocks().pessimistic())).releaseExclusive((ResourceType)ResourceTypes.LABEL, new long[]{this.descriptor.getLabelId()});
        ((Locks.Client)Mockito.verify((Object)transaction.statementLocks().pessimistic())).acquireExclusive(transaction.lockTracer(), (ResourceType)ResourceTypes.LABEL, new long[]{this.descriptor.getLabelId()});
    }

    @Test
    public void shouldReuseExistingOrphanedConstraintIndex() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        long orphanedConstraintIndexId = 111L;
        Mockito.when((Object)this.schemaRead.indexGetCommittedId((IndexReference)this.indexReference)).thenReturn((Object)orphanedConstraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(orphanedConstraintIndexId)).thenReturn((Object)indexProxy);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        Mockito.when((Object)this.schemaRead.index(123, new int[]{456})).thenReturn((Object)this.indexReference);
        Mockito.when((Object)this.schemaRead.indexGetOwningUniquenessConstraintId((IndexReference)this.indexReference)).thenReturn(null);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, (LogProvider)this.logProvider);
        KernelTransactionImplementation transaction = this.createTransaction();
        long indexId = creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, null);
        Assert.assertEquals((long)orphanedConstraintIndexId, (long)indexId);
        Assert.assertEquals((String)"There should have been no need to acquire a statement to create the constraint index", (long)0L, (long)kernel.transactions.size());
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetCommittedId((IndexReference)this.indexReference);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index(123, new int[]{456});
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetOwningUniquenessConstraintId((IndexReference)this.indexReference);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted();
    }

    @Test
    public void shouldFailOnExistingOwnedConstraintIndex() throws Exception {
        StatementOperationParts indexCreationContext = StatementOperationsTestHelper.mockedParts();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        long constraintIndexId = 111L;
        long constraintIndexOwnerId = 222L;
        Mockito.when((Object)this.schemaRead.indexGetCommittedId((IndexReference)this.indexReference)).thenReturn((Object)constraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(constraintIndexId)).thenReturn((Object)indexProxy);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        Mockito.when((Object)this.schemaRead.index(123, new int[]{456})).thenReturn((Object)this.indexReference);
        Mockito.when((Object)this.schemaRead.indexGetOwningUniquenessConstraintId((IndexReference)this.indexReference)).thenReturn((Object)constraintIndexOwnerId);
        Mockito.when((Object)this.tokenRead.nodeLabelName(123)).thenReturn((Object)"MyLabel");
        Mockito.when((Object)this.tokenRead.propertyKeyName(456)).thenReturn((Object)"MyKey");
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, (LogProvider)this.logProvider);
        try {
            KernelTransactionImplementation transaction = this.createTransaction();
            creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, null);
            Assert.fail((String)"Should've failed");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"There should have been no need to acquire a statement to create the constraint index", (long)0L, (long)kernel.transactions.size());
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index(123, new int[]{456});
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetOwningUniquenessConstraintId((IndexReference)this.indexReference);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
    }

    @Test
    public void shouldCreateConstraintIndexForSpecifiedProvider() throws Exception {
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        long constraintIndexId = 111L;
        Mockito.when((Object)this.schemaRead.indexGetCommittedId((IndexReference)this.indexReference)).thenReturn((Object)constraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(constraintIndexId)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, (LogProvider)this.logProvider);
        IndexProvider.Descriptor providerDescriptor = new IndexProvider.Descriptor("Groovy", "1.2");
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, providerDescriptor);
        Assert.assertEquals((long)1L, (long)kernel.transactions.size());
        TransactionState transactionState = ((KernelTransactionImplementation)kernel.transactions.get(0)).txState();
        ((TransactionState)Mockito.verify((Object)transactionState)).indexRuleDoAdd(SchemaIndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.descriptor), providerDescriptor);
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).index(123, new int[]{456});
        ((SchemaRead)Mockito.verify((Object)this.schemaRead)).indexGetCommittedId((IndexReference)ArgumentMatchers.any(IndexReference.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaRead});
    }

    @Test
    public void logMessagesAboutConstraintCreation() throws SchemaKernelException, UniquePropertyValueValidationException, TransactionFailureException, IndexNotFoundKernelException {
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        long constraintIndexId = 111L;
        Mockito.when((Object)this.schemaRead.indexGetCommittedId((IndexReference)this.indexReference)).thenReturn((Object)constraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(constraintIndexId)).thenReturn((Object)indexProxy);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)this.descriptor)).thenReturn((Object)indexProxy);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, (LogProvider)this.logProvider);
        IndexProvider.Descriptor providerDescriptor = new IndexProvider.Descriptor("indexProvider", "1.0");
        KernelTransactionImplementation transaction = this.createTransaction();
        creator.createUniquenessConstraintIndex(transaction, (SchemaDescriptor)this.descriptor, providerDescriptor);
        this.logProvider.assertContainsLogCallContaining("Starting constraint creation: %s.");
        this.logProvider.assertContainsLogCallContaining("Constraint %s populated, starting verification.");
        this.logProvider.assertContainsLogCallContaining("Constraint %s verified.");
    }

    private SchemaRead schemaRead() {
        SchemaRead schemaRead = (SchemaRead)Mockito.mock(SchemaRead.class);
        Mockito.when((Object)schemaRead.index(123, new int[]{456})).thenReturn((Object)CapableIndexReference.NO_INDEX);
        try {
            Mockito.when((Object)schemaRead.indexGetCommittedId((IndexReference)this.indexReference)).thenReturn((Object)2468L);
        }
        catch (SchemaKernelException e) {
            throw new AssertionError((Object)e);
        }
        return schemaRead;
    }

    private KernelTransactionImplementation createTransaction() {
        TransactionHeaderInformation headerInformation = new TransactionHeaderInformation(-1, -1, new byte[0]);
        TransactionHeaderInformationFactory headerInformationFactory = (TransactionHeaderInformationFactory)Mockito.mock(TransactionHeaderInformationFactory.class);
        Mockito.when((Object)headerInformationFactory.create()).thenReturn((Object)headerInformation);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        Mockito.when((Object)storeReadLayer.newStatement()).thenReturn((Object)storageStatement);
        Mockito.when((Object)storageEngine.storeReadLayer()).thenReturn((Object)storeReadLayer);
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        SimpleStatementLocks locks = new SimpleStatementLocks((Locks.Client)Mockito.mock(Locks.Client.class));
        Mockito.when((Object)transaction.statementLocks()).thenReturn((Object)locks);
        Mockito.when((Object)transaction.tokenRead()).thenReturn((Object)this.tokenRead);
        Mockito.when((Object)transaction.schemaRead()).thenReturn((Object)this.schemaRead);
        TransactionState transactionState = (TransactionState)Mockito.mock(TransactionState.class);
        Mockito.when((Object)transaction.txState()).thenReturn((Object)transactionState);
        return transaction;
    }

    private class StubKernel
    implements Kernel,
    Session {
        private final List<KernelTransactionImplementation> transactions = new ArrayList<KernelTransactionImplementation>();

        private StubKernel() {
        }

        public Transaction beginTransaction() {
            return this.remember(ConstraintIndexCreatorTest.this.createTransaction());
        }

        public Transaction beginTransaction(Transaction.Type type) {
            return this.remember(ConstraintIndexCreatorTest.this.createTransaction());
        }

        private KernelTransaction remember(KernelTransactionImplementation kernelTransaction) {
            this.transactions.add(kernelTransaction);
            return kernelTransaction;
        }

        public Session beginSession(LoginContext loginContext) {
            return this;
        }

        public Modes modes() {
            return null;
        }

        public void close() {
        }
    }
}

