/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexMeta;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class FailedIndexProxyTest {
    private final IndexProvider.Descriptor providerDescriptor = (IndexProvider.Descriptor)Mockito.mock(IndexProvider.Descriptor.class);
    private final IndexCapability indexCapability = (IndexCapability)Mockito.mock(IndexCapability.class);
    private final IndexPopulator indexPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
    private final IndexPopulationFailure indexPopulationFailure = (IndexPopulationFailure)Mockito.mock(IndexPopulationFailure.class);
    private final IndexCountsRemover indexCountsRemover = (IndexCountsRemover)Mockito.mock(IndexCountsRemover.class);

    @Test
    public void shouldRemoveIndexCountsWhenTheIndexItselfIsDropped() throws IOException {
        String userDescription = "description";
        FailedIndexProxy index = new FailedIndexProxy(this.indexMeta(SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2})), userDescription, this.indexPopulator, this.indexPopulationFailure, this.indexCountsRemover, (LogProvider)NullLogProvider.getInstance());
        index.drop();
        ((IndexPopulator)Mockito.verify((Object)this.indexPopulator)).drop();
        ((IndexCountsRemover)Mockito.verify((Object)this.indexCountsRemover)).remove();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexPopulator, this.indexCountsRemover});
    }

    @Test
    public void shouldLogReasonForDroppingIndex() throws IOException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        new FailedIndexProxy(this.indexMeta(SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0})), "foo", (IndexPopulator)Mockito.mock(IndexPopulator.class), IndexPopulationFailure.failure((String)"it broke"), this.indexCountsRemover, (LogProvider)logProvider).drop();
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(FailedIndexProxy.class).info("FailedIndexProxy#drop index on foo dropped due to:\nit broke")});
    }

    private IndexMeta indexMeta(SchemaIndexDescriptor descriptor) {
        return new IndexMeta(1L, descriptor, this.providerDescriptor, this.indexCapability);
    }
}

