/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.test.Race;

public class IndexMapReferenceTest {
    @Test
    public void shouldSynchronizeModifications() throws Throwable {
        int i;
        IndexMapReference ref = new IndexMapReference();
        IndexProxy[] existing = this.mockedIndexProxies(5, 0);
        ref.modify(indexMap -> {
            for (int i = 0; i < existing.length; ++i) {
                indexMap.putIndexProxy((long)i, existing[i]);
            }
            return indexMap;
        });
        Race race = new Race();
        for (int i2 = 0; i2 < existing.length; ++i2) {
            race.addContestant(this.removeIndexProxy(ref, i2), 1);
        }
        IndexProxy[] created = this.mockedIndexProxies(3, existing.length);
        for (i = 0; i < existing.length; ++i) {
            race.addContestant(this.putIndexProxy(ref, existing.length + i, created[i]), 1);
        }
        race.go();
        for (i = 0; i < existing.length; ++i) {
            Assert.assertNull((Object)ref.getIndexProxy((long)i));
        }
        for (i = 0; i < created.length; ++i) {
            Assert.assertSame((Object)created[i], (Object)ref.getIndexProxy((long)(existing.length + i)));
        }
    }

    private Runnable putIndexProxy(IndexMapReference ref, long indexId, IndexProxy proxy) {
        return () -> ref.modify(indexMap -> {
            indexMap.putIndexProxy(indexId, proxy);
            return indexMap;
        });
    }

    private Runnable removeIndexProxy(IndexMapReference ref, long indexId) {
        return () -> ref.modify(indexMap -> {
            indexMap.removeIndexProxy(indexId);
            return indexMap;
        });
    }

    private IndexProxy[] mockedIndexProxies(int base, int count) {
        IndexProxy[] existing = new IndexProxy[count];
        for (int i = 0; i < count; ++i) {
            existing[i] = (IndexProxy)Mockito.mock(IndexProxy.class);
            Mockito.when((Object)existing[i].getDescriptor()).thenReturn((Object)SchemaIndexDescriptorFactory.forLabel((int)(base + i), (int[])new int[]{1}));
        }
        return existing;
    }
}

