/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class RelationshipIT
extends KernelIntegrationTest {
    @Rule
    public OtherThreadRule<Object> otherThread = new OtherThreadRule(10L, TimeUnit.SECONDS);

    @Test
    public void shouldListRelationshipsInCurrentAndSubsequentTx() throws Exception {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType1 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type1");
        int relType2 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type2");
        long refNode = transaction.dataWrite().nodeCreate();
        long otherNode = transaction.dataWrite().nodeCreate();
        long fromRefToOther1 = transaction.dataWrite().relationshipCreate(refNode, relType1, otherNode);
        long fromRefToOther2 = transaction.dataWrite().relationshipCreate(refNode, relType2, otherNode);
        long fromOtherToRef = transaction.dataWrite().relationshipCreate(otherNode, relType1, refNode);
        long fromRefToRef = transaction.dataWrite().relationshipCreate(refNode, relType2, refNode);
        long endNode = transaction.dataWrite().nodeCreate();
        long fromRefToThird = transaction.dataWrite().relationshipCreate(refNode, relType2, endNode);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.BOTH), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relType1}), fromRefToOther1, fromOtherToRef);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.INCOMING), fromOtherToRef);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.INCOMING, new int[]{relType1}), new long[0]);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.OUTGOING, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToThird, fromRefToRef);
        this.commit();
        transaction = this.newTransaction();
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.BOTH), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relType1}), fromRefToOther1, fromOtherToRef);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.INCOMING), fromOtherToRef);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.INCOMING, new int[]{relType1}), new long[0]);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.OUTGOING, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToThird, fromRefToRef);
        this.commit();
    }

    @Test
    public void shouldInterleaveModifiedRelationshipsWithExistingOnes() throws Exception {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType1 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type1");
        int relType2 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type2");
        long refNode = transaction.dataWrite().nodeCreate();
        long otherNode = transaction.dataWrite().nodeCreate();
        long fromRefToOther1 = transaction.dataWrite().relationshipCreate(refNode, relType1, otherNode);
        long fromRefToOther2 = transaction.dataWrite().relationshipCreate(refNode, relType2, otherNode);
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        transaction.dataWrite().relationshipDelete(fromRefToOther1);
        long endNode = transaction.dataWrite().nodeCreate();
        long localTxRel = transaction.dataWrite().relationshipCreate(refNode, relType1, endNode);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.BOTH), fromRefToOther2, localTxRel);
        this.assertRelsInSeparateTx(refNode, Direction.BOTH, fromRefToOther1, fromRefToOther2);
        this.commit();
    }

    @Test
    public void shouldReturnRelsWhenAskingForRelsWhereOnlySomeTypesExistInCurrentRel() throws Exception {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType1 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type1");
        int relType2 = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type2");
        long refNode = transaction.dataWrite().nodeCreate();
        long otherNode = transaction.dataWrite().nodeCreate();
        long theRel = transaction.dataWrite().relationshipCreate(refNode, relType1, otherNode);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.OUTGOING, new int[]{relType2, relType1}), theRel);
        this.commit();
    }

    @Test
    public void askingForNonExistantReltypeOnDenseNodeShouldNotCorruptState() throws Exception {
        long[] rels = new long[200];
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relTypeTheNodeDoesUse = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type1");
        int relTypeTheNodeDoesNotUse = transaction.tokenWrite().relationshipTypeGetOrCreateForName("Type2");
        long refNode = transaction.dataWrite().nodeCreate();
        long otherNode = transaction.dataWrite().nodeCreate();
        for (int i = 0; i < rels.length; ++i) {
            rels[i] = transaction.dataWrite().relationshipCreate(refNode, relTypeTheNodeDoesUse, otherNode);
        }
        this.commit();
        transaction = this.newTransaction();
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.INCOMING, new int[]{relTypeTheNodeDoesNotUse}), new long[0]);
        this.assertRels(this.nodeGetRelationships(transaction, refNode, Direction.BOTH, new int[]{relTypeTheNodeDoesUse}), rels);
        this.commit();
    }

    private void assertRelsInSeparateTx(long refNode, Direction both, long ... longs) throws InterruptedException, ExecutionException, TimeoutException {
        Assert.assertTrue((boolean)((Boolean)this.otherThread.execute(state -> {
            try (Transaction ktx = this.session.beginTransaction();){
                this.assertRels(this.nodeGetRelationships(ktx, refNode, both), longs);
            }
            return true;
        }).get(10L, TimeUnit.SECONDS)));
    }

    private void assertRels(Iterator<Long> it, long ... rels) {
        ArrayList<Matcher> all = new ArrayList<Matcher>(rels.length);
        for (long element : rels) {
            all.add(CoreMatchers.hasItem((Object)element));
        }
        List list = Iterators.asList(it);
        Assert.assertThat((Object)list, (Matcher)AllOf.allOf(all));
    }
}

