/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.api.store.StoreIteratorRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;

public class StoreIteratorRelationshipCursorTest {
    private static final long RELATIONSHIP_ID = 1L;

    @Test
    public void retrieveUsedRelationship() {
        RelationshipRecord relationshipRecord = new RelationshipRecord(-1L);
        RecordCursor recordCursor = (RecordCursor)Mockito.mock(RecordCursor.class);
        RelationshipStore relationshipStore = this.getRelationshipStore(relationshipRecord, recordCursor);
        Mockito.when((Object)recordCursor.next(1L, (AbstractBaseRecord)relationshipRecord, RecordLoad.CHECK)).thenAnswer((Answer)new RelationshipAnswer(relationshipRecord, true));
        try (StoreIteratorRelationshipCursor cursor = this.createRelationshipCursor(relationshipRecord, relationshipStore);){
            cursor.init(PrimitiveLongCollections.iterator((long[])new long[]{1L}));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)1L, (long)cursor.get().id());
        }
    }

    @Test
    public void retrieveUnusedRelationship() {
        RelationshipRecord relationshipRecord = new RelationshipRecord(-1L);
        RecordCursor recordCursor = (RecordCursor)Mockito.mock(RecordCursor.class);
        RelationshipStore relationshipStore = this.getRelationshipStore(relationshipRecord, recordCursor);
        Mockito.when((Object)recordCursor.next(1L, (AbstractBaseRecord)relationshipRecord, RecordLoad.CHECK)).thenAnswer((Answer)new RelationshipAnswer(relationshipRecord, false));
        try (StoreIteratorRelationshipCursor cursor = this.createRelationshipCursor(relationshipRecord, relationshipStore);){
            cursor.init(PrimitiveLongCollections.iterator((long[])new long[]{1L}));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((long)1L, (long)cursor.get().id());
        }
    }

    private StoreIteratorRelationshipCursor createRelationshipCursor(RelationshipRecord relationshipRecord, RelationshipStore relationshipStore) {
        RecordCursors recordCursors = StoreIteratorRelationshipCursorTest.newRecordCursorsWithMockedNeoStores(relationshipStore);
        TestCursorCache instanceCache = new TestCursorCache();
        return new StoreIteratorRelationshipCursor(relationshipRecord, (InstanceCache)instanceCache, recordCursors, LockService.NO_LOCK_SERVICE);
    }

    private RelationshipStore getRelationshipStore(RelationshipRecord relationshipRecord, RecordCursor recordCursor) {
        RelationshipStore relationshipStore = (RelationshipStore)Mockito.mock(RelationshipStore.class);
        Mockito.when((Object)recordCursor.acquire(ArgumentMatchers.anyLong(), (RecordLoad)ArgumentMatchers.any())).thenReturn((Object)recordCursor);
        Mockito.when((Object)relationshipStore.newRecord()).thenReturn((Object)relationshipRecord);
        Mockito.when((Object)relationshipStore.newRecordCursor((AbstractBaseRecord)relationshipRecord)).thenReturn((Object)recordCursor);
        return relationshipStore;
    }

    private static RecordCursors newRecordCursorsWithMockedNeoStores(RelationshipStore relationshipStore) {
        NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
        NodeStore nodeStore = StoreIteratorRelationshipCursorTest.newStoreMockWithRecordCursor(NodeStore.class);
        RelationshipGroupStore relGroupStore = StoreIteratorRelationshipCursorTest.newStoreMockWithRecordCursor(RelationshipGroupStore.class);
        PropertyStore propertyStore = StoreIteratorRelationshipCursorTest.newStoreMockWithRecordCursor(PropertyStore.class);
        DynamicStringStore dynamicStringStore = StoreIteratorRelationshipCursorTest.newStoreMockWithRecordCursor(DynamicStringStore.class);
        DynamicArrayStore dynamicArrayStore = StoreIteratorRelationshipCursorTest.newStoreMockWithRecordCursor(DynamicArrayStore.class);
        DynamicArrayStore dynamicLabelStore = StoreIteratorRelationshipCursorTest.newStoreMockWithRecordCursor(DynamicArrayStore.class);
        Mockito.when((Object)neoStores.getNodeStore()).thenReturn((Object)nodeStore);
        Mockito.when((Object)neoStores.getRelationshipStore()).thenReturn((Object)relationshipStore);
        Mockito.when((Object)neoStores.getRelationshipGroupStore()).thenReturn((Object)relGroupStore);
        Mockito.when((Object)neoStores.getPropertyStore()).thenReturn((Object)propertyStore);
        Mockito.when((Object)propertyStore.getStringStore()).thenReturn((Object)dynamicStringStore);
        Mockito.when((Object)propertyStore.getArrayStore()).thenReturn((Object)dynamicArrayStore);
        Mockito.when((Object)nodeStore.getDynamicLabelStore()).thenReturn((Object)dynamicLabelStore);
        return new RecordCursors(neoStores);
    }

    private static <S extends RecordStore<R>, R extends AbstractBaseRecord> S newStoreMockWithRecordCursor(Class<S> storeClass) {
        RecordStore storeMock = (RecordStore)Mockito.mock(storeClass);
        RecordCursor cursor = StoreIteratorRelationshipCursorTest.newCursorMock();
        Mockito.when((Object)storeMock.newRecordCursor((AbstractBaseRecord)ArgumentMatchers.any())).thenReturn(cursor);
        return (S)storeMock;
    }

    private static <T extends AbstractBaseRecord> RecordCursor<T> newCursorMock() {
        RecordCursor cursor = (RecordCursor)Mockito.mock(RecordCursor.class);
        Mockito.when((Object)cursor.acquire(ArgumentMatchers.anyLong(), (RecordLoad)ArgumentMatchers.any())).thenReturn((Object)cursor);
        return cursor;
    }

    private class TestCursorCache
    extends InstanceCache<StoreIteratorRelationshipCursor> {
        private TestCursorCache() {
        }

        protected StoreIteratorRelationshipCursor create() {
            return null;
        }
    }

    private static class RelationshipAnswer
    implements Answer<Boolean> {
        private final RelationshipRecord relationshipRecord;
        private boolean used;

        RelationshipAnswer(RelationshipRecord relationshipRecord, boolean used) {
            this.relationshipRecord = relationshipRecord;
            this.used = used;
        }

        public Boolean answer(InvocationOnMock invocationOnMock) {
            this.relationshipRecord.setInUse(this.used);
            this.relationshipRecord.setId(1L);
            return true;
        }
    }
}

