/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.values.storable.Values;

public class IteratingPropertyReceiverTest {
    @Test
    public void shouldAcceptAndThenIterateOverProperties() {
        IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
        int propertyCount = 100;
        for (int i = 0; i < propertyCount; ++i) {
            receiver.receive((StorageProperty)new PropertyKeyValue(1, Values.of((Object)i)), 5L);
        }
        int count = 0;
        while (receiver.hasNext()) {
            StorageProperty property = (StorageProperty)receiver.next();
            Assert.assertEquals((Object)Values.of((Object)count++), (Object)property.value());
        }
        Assert.assertFalse((boolean)receiver.hasNext());
        Assert.assertEquals((long)propertyCount, (long)count);
    }
}

