/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.LabelScanWriteMonitor;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LabelScanWriteMonitorTest {
    @Rule
    public final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);

    @Test
    public void shouldRotateExistingFileOnOpen() {
        LabelScanWriteMonitor writeMonitor = new LabelScanWriteMonitor((FileSystemAbstraction)this.fs, this.directory.directory());
        writeMonitor.close();
        LabelScanWriteMonitor secondWriteMonitor = new LabelScanWriteMonitor((FileSystemAbstraction)this.fs, this.directory.directory());
        secondWriteMonitor.close();
        Assert.assertEquals((long)2L, (long)this.directory.directory().listFiles((dir, name) -> name.startsWith("neostore.labelscanstore.db.writelog")).length);
    }

    @Test
    public void shouldLogAndDumpData() throws IOException {
        File storeDir = this.directory.directory();
        LabelScanWriteMonitor writeMonitor = new LabelScanWriteMonitor((FileSystemAbstraction)this.fs, storeDir);
        LabelScanValue value = new LabelScanValue();
        writeMonitor.range(3L, 0);
        writeMonitor.prepareAdd(123L, 4);
        writeMonitor.prepareAdd(123L, 5);
        writeMonitor.mergeAdd(new LabelScanValue(), value.set(4).set(5));
        writeMonitor.flushPendingUpdates();
        writeMonitor.prepareRemove(124L, 5);
        writeMonitor.mergeRemove(value, new LabelScanValue().set(5));
        writeMonitor.writeSessionEnded();
        writeMonitor.range(5L, 1);
        writeMonitor.prepareAdd(125L, 10);
        writeMonitor.mergeAdd(new LabelScanValue().set(9), new LabelScanValue().set(10));
        writeMonitor.flushPendingUpdates();
        writeMonitor.writeSessionEnded();
        writeMonitor.close();
        LabelScanWriteMonitor.Dumper dumper = (LabelScanWriteMonitor.Dumper)Mockito.mock(LabelScanWriteMonitor.Dumper.class);
        LabelScanWriteMonitor.dump((FileSystemAbstraction)this.fs, (File)storeDir, (LabelScanWriteMonitor.Dumper)dumper, null);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{dumper});
        ((LabelScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).prepare(true, 0L, 0L, 123L, 196L, 0);
        ((LabelScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).prepare(true, 0L, 0L, 123L, 197L, 0);
        ((LabelScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).merge(true, 0L, 0L, 3L, 0, 0L, 48L);
        ((LabelScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).prepare(false, 0L, 1L, 124L, 197L, 0);
        ((LabelScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).merge(false, 0L, 1L, 3L, 0, 48L, 32L);
        ((LabelScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).prepare(true, 1L, 0L, 125L, 330L, 1);
        ((LabelScanWriteMonitor.Dumper)inOrder.verify((Object)dumper)).merge(true, 1L, 0L, 5L, 1, 512L, 1024L);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldParseSimpleSingleTxFilter() {
        LabelScanWriteMonitor.TxFilter txFilter = LabelScanWriteMonitor.parseTxFilter((String)"123");
        Assert.assertFalse((boolean)txFilter.contains(122L));
        Assert.assertTrue((boolean)txFilter.contains(123L));
        Assert.assertFalse((boolean)txFilter.contains(124L));
    }

    @Test
    public void shouldParseRangedSingleTxFilter() {
        LabelScanWriteMonitor.TxFilter txFilter = LabelScanWriteMonitor.parseTxFilter((String)"123-126");
        Assert.assertFalse((boolean)txFilter.contains(122L));
        Assert.assertTrue((boolean)txFilter.contains(123L));
        Assert.assertTrue((boolean)txFilter.contains(124L));
        Assert.assertTrue((boolean)txFilter.contains(125L));
        Assert.assertTrue((boolean)txFilter.contains(126L));
        Assert.assertFalse((boolean)txFilter.contains(127L));
    }

    @Test
    public void shouldParseSimpleMultipleTxFilters() {
        LabelScanWriteMonitor.TxFilter txFilter = LabelScanWriteMonitor.parseTxFilter((String)"123,146,123456");
        Assert.assertFalse((boolean)txFilter.contains(122L));
        Assert.assertTrue((boolean)txFilter.contains(123L));
        Assert.assertTrue((boolean)txFilter.contains(146L));
        Assert.assertTrue((boolean)txFilter.contains(123456L));
        Assert.assertFalse((boolean)txFilter.contains(147L));
    }

    @Test
    public void shouldParseRangedMultipleTxFilters() {
        LabelScanWriteMonitor.TxFilter txFilter = LabelScanWriteMonitor.parseTxFilter((String)"123-125,345-567");
        Assert.assertFalse((boolean)txFilter.contains(122L));
        Assert.assertTrue((boolean)txFilter.contains(123L));
        Assert.assertTrue((boolean)txFilter.contains(124L));
        Assert.assertTrue((boolean)txFilter.contains(125L));
        Assert.assertFalse((boolean)txFilter.contains(201L));
        Assert.assertTrue((boolean)txFilter.contains(345L));
        Assert.assertTrue((boolean)txFilter.contains(405L));
        Assert.assertTrue((boolean)txFilter.contains(567L));
        Assert.assertFalse((boolean)txFilter.contains(568L));
    }

    @Test
    public void shouldRotateAtConfiguredThreshold() {
        File storeDir = this.directory.directory();
        int rotationThreshold = 1000;
        LabelScanWriteMonitor writeMonitor = new LabelScanWriteMonitor((FileSystemAbstraction)this.fs, storeDir, (long)rotationThreshold, ByteUnit.Byte, 1L, TimeUnit.DAYS);
        int i = 0;
        while (storeDir.listFiles().length < 5) {
            writeMonitor.range((long)i, 1);
            writeMonitor.prepareAdd((long)i, 5);
            writeMonitor.mergeAdd(new LabelScanValue(), new LabelScanValue().set(5));
            writeMonitor.writeSessionEnded();
            ++i;
        }
        writeMonitor.close();
        for (File file : storeDir.listFiles((dir, name) -> !name.equals("neostore.labelscanstore.db.writelog"))) {
            long sizeDiff = Math.abs((long)rotationThreshold - this.fs.getFileSize(file));
            Assert.assertTrue(((double)sizeDiff < (double)rotationThreshold / 10.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void shouldPruneAtConfiguredThreshold() {
        File storeDir = this.directory.directory();
        int pruneThreshold = 200;
        LabelScanWriteMonitor writeMonitor = new LabelScanWriteMonitor((FileSystemAbstraction)this.fs, storeDir, 1000L, ByteUnit.Byte, (long)pruneThreshold, TimeUnit.MILLISECONDS);
        long startTime = System.currentTimeMillis();
        long endTime = startTime + TimeUnit.SECONDS.toMillis(1L);
        int i = 0;
        while (System.currentTimeMillis() < endTime) {
            writeMonitor.range((long)i, 1);
            writeMonitor.prepareAdd((long)i, 5);
            writeMonitor.mergeAdd(new LabelScanValue(), new LabelScanValue().set(5));
            writeMonitor.writeSessionEnded();
            ++i;
        }
        writeMonitor.close();
        for (File file : storeDir.listFiles((dir, name) -> !name.equals("neostore.labelscanstore.db.writelog"))) {
            long timestamp = LabelScanWriteMonitor.millisOf((File)file);
            long diff = endTime - timestamp;
            Assert.assertTrue((diff < (long)(pruneThreshold * 2) ? 1 : 0) != 0);
        }
    }
}

