/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class NativeLabelScanStoreRebuildTest {
    private PageCacheRule pageCacheRule = new PageCacheRule();
    private FileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule).around((TestRule)this.testDirectory);
    private static final FullStoreChangeStream THROWING_STREAM = writer -> {
        throw new IllegalArgumentException();
    };
    private File storeDir;

    @Before
    public void setup() {
        this.storeDir = this.testDirectory.graphDbDir();
    }

    @Test
    public void mustBeDirtyIfFailedDuringRebuild() throws Exception {
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystemRule.get());
        this.createDirtyIndex(pageCache);
        RecordingMonitor monitor = new RecordingMonitor();
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)monitor, new String[0]);
        NativeLabelScanStore nativeLabelScanStore = new NativeLabelScanStore(pageCache, (FileSystemAbstraction)this.fileSystemRule, this.storeDir, FullStoreChangeStream.EMPTY, false, monitors, RecoveryCleanupWorkCollector.immediate());
        nativeLabelScanStore.init();
        nativeLabelScanStore.start();
        Assert.assertTrue((boolean)monitor.notValid);
        Assert.assertTrue((boolean)monitor.rebuilding);
        Assert.assertTrue((boolean)monitor.rebuilt);
        nativeLabelScanStore.shutdown();
    }

    @Test
    public void doNotRebuildIfOpenedInReadOnlyModeAndIndexIsNotClean() throws IOException {
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystemRule.get());
        this.createDirtyIndex(pageCache);
        Monitors monitors = new Monitors();
        RecordingMonitor monitor = new RecordingMonitor();
        monitors.addMonitorListener((Object)monitor, new String[0]);
        NativeLabelScanStore nativeLabelScanStore = new NativeLabelScanStore(pageCache, (FileSystemAbstraction)this.fileSystemRule, this.storeDir, FullStoreChangeStream.EMPTY, true, monitors, RecoveryCleanupWorkCollector.ignore());
        nativeLabelScanStore.init();
        nativeLabelScanStore.start();
        Assert.assertTrue((boolean)monitor.notValid);
        Assert.assertFalse((boolean)monitor.rebuilt);
        Assert.assertFalse((boolean)monitor.rebuilding);
        nativeLabelScanStore.shutdown();
    }

    @Test
    public void labelScanStoreIsDirtyWhenIndexIsNotClean() throws IOException {
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystemRule.get());
        this.createDirtyIndex(pageCache);
        Monitors monitors = new Monitors();
        RecordingMonitor monitor = new RecordingMonitor();
        monitors.addMonitorListener((Object)monitor, new String[0]);
        NativeLabelScanStore nativeLabelScanStore = new NativeLabelScanStore(pageCache, (FileSystemAbstraction)this.fileSystemRule, this.storeDir, FullStoreChangeStream.EMPTY, true, monitors, RecoveryCleanupWorkCollector.ignore());
        nativeLabelScanStore.init();
        nativeLabelScanStore.start();
        Assert.assertTrue((boolean)nativeLabelScanStore.isDirty());
        nativeLabelScanStore.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailOnUnsortedLabelsFromFullStoreChangeStream() throws Exception {
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystemRule.get());
        ArrayList<NodeLabelUpdate> existingData = new ArrayList<NodeLabelUpdate>();
        existingData.add(NodeLabelUpdate.labelChanges((long)1L, (long[])new long[0], (long[])new long[]{2L, 1L}));
        FullStoreChangeStream changeStream = FullStoreChangeStream.asStream(existingData);
        NativeLabelScanStore nativeLabelScanStore = null;
        try {
            nativeLabelScanStore = new NativeLabelScanStore(pageCache, (FileSystemAbstraction)this.fileSystemRule, this.storeDir, changeStream, false, new Monitors(), RecoveryCleanupWorkCollector.immediate());
            nativeLabelScanStore.init();
            nativeLabelScanStore.start();
            Assert.fail((String)"Expected native label scan store to fail on ");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"unsorted label"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.stringContainsInOrder((Iterable)Iterables.asIterable((Object[])new String[]{"2", "1"})));
        }
        finally {
            if (nativeLabelScanStore != null) {
                nativeLabelScanStore.shutdown();
            }
        }
    }

    private void createDirtyIndex(PageCache pageCache) throws IOException {
        block2: {
            NativeLabelScanStore nativeLabelScanStore = null;
            try {
                nativeLabelScanStore = new NativeLabelScanStore(pageCache, (FileSystemAbstraction)this.fileSystemRule, this.storeDir, THROWING_STREAM, false, new Monitors(), RecoveryCleanupWorkCollector.immediate());
                nativeLabelScanStore.init();
                nativeLabelScanStore.start();
            }
            catch (IllegalArgumentException e) {
                if (nativeLabelScanStore == null) break block2;
                nativeLabelScanStore.shutdown();
            }
        }
    }

    private class RecordingMonitor
    extends LabelScanStore.Monitor.Adaptor {
        boolean notValid;
        boolean rebuilding;
        boolean rebuilt;

        private RecordingMonitor() {
        }

        public void notValidIndex() {
            this.notValid = true;
        }

        public void rebuilding() {
            this.rebuilding = true;
        }

        public void rebuilt(long roughNodeCount) {
            this.rebuilt = true;
        }
    }
}

